/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractInjectionChecker;
import org.sonar.java.checks.helpers.MethodsHelper;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2077")
public class SQLInjectionCheck
extends AbstractInjectionChecker {
    private static final MethodMatcher HIBERNATE_SESSION_CREATE_QUERY_MATCHER = MethodMatcher.create().callSite(TypeCriteria.subtypeOf((String)"org.hibernate.Session")).name("createQuery").withAnyParameters();
    private static final MethodMatcher STATEMENT_EXECUTE_QUERY_MATCHER = MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"java.sql.Statement")).name("executeQuery").withAnyParameters();
    private static final MethodMatcherCollection CONNECTION_MATCHERS = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"java.sql.Connection")).name("prepareStatement").withAnyParameters(), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"java.sql.Connection")).name("prepareCall").withAnyParameters()});
    private static final MethodMatcher ENTITY_MANAGER_CREATE_NATIVE_QUERY_MATCHER = MethodMatcher.create().typeDefinition("javax.persistence.EntityManager").name("createNativeQuery").withAnyParameters();

    public void visitNode(Tree tree) {
        MethodInvocationTree methodTree = (MethodInvocationTree)tree;
        boolean isHibernateCall = SQLInjectionCheck.isHibernateCall(methodTree);
        if (isHibernateCall || SQLInjectionCheck.isExecuteQueryOrPrepareStatement(methodTree) || SQLInjectionCheck.isEntityManagerCreateNativeQuery(methodTree)) {
            ExpressionTree arg = (ExpressionTree)methodTree.arguments().get(0);
            this.parameterName = "";
            if (this.isDynamicString((Tree)methodTree, arg, null, true)) {
                String message = "\"" + this.parameterName + "\" is provided externally to the method and not sanitized before use.";
                if (isHibernateCall) {
                    message = "Use Hibernate's parameter binding instead of concatenation.";
                }
                this.reportIssue((Tree)MethodsHelper.methodName(methodTree), message);
            }
        }
    }

    private static boolean isExecuteQueryOrPrepareStatement(MethodInvocationTree methodTree) {
        return !methodTree.arguments().isEmpty() && (STATEMENT_EXECUTE_QUERY_MATCHER.matches(methodTree) || CONNECTION_MATCHERS.anyMatch(methodTree));
    }

    private static boolean isHibernateCall(MethodInvocationTree methodTree) {
        return HIBERNATE_SESSION_CREATE_QUERY_MATCHER.matches(methodTree);
    }

    private static boolean isEntityManagerCreateNativeQuery(MethodInvocationTree methodTree) {
        return ENTITY_MANAGER_CREATE_NATIVE_QUERY_MATCHER.matches(methodTree);
    }
}

