/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1151")
public class SwitchCaseTooBigCheck
extends IssuableSubscriptionVisitor {
    private static final int DEFAULT_MAX = 5;
    @RuleProperty(description="Maximum number of lines", defaultValue="5")
    public int max = 5;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.SWITCH_STATEMENT);
    }

    public void visitNode(Tree tree) {
        SwitchStatementTree switchStatementTree = (SwitchStatementTree)tree;
        for (CaseGroupTree caseGroupTree : switchStatementTree.cases()) {
            List labels = caseGroupTree.labels();
            for (int i = 0; i < labels.size() - 1; ++i) {
                CaseLabelTree currentLabel = (CaseLabelTree)labels.get(i);
                int caseStartLine = SwitchCaseTooBigCheck.line((Tree)currentLabel);
                int nextCaseStartLine = SwitchCaseTooBigCheck.line((Tree)labels.get(i + 1));
                this.check(currentLabel, caseStartLine, nextCaseStartLine);
            }
            CaseLabelTree lastLabel = (CaseLabelTree)Iterables.getLast((Iterable)labels);
            int lastLabelLine = SwitchCaseTooBigCheck.line((Tree)lastLabel);
            int statementLine = SwitchCaseTooBigCheck.firstStatementLine(caseGroupTree.body(), lastLabelLine);
            int startLine = Math.min(lastLabelLine + 1, statementLine);
            int endLine = SwitchCaseTooBigCheck.getNextLine(switchStatementTree, caseGroupTree);
            this.check(lastLabel, startLine, endLine);
        }
    }

    private static int firstStatementLine(List<StatementTree> body, int lastLabelLine) {
        if (!body.isEmpty()) {
            StatementTree firstStatement = body.get(0);
            int firstStatementLine = SwitchCaseTooBigCheck.line((Tree)body.get(0));
            List trivias = firstStatement.firstToken().trivias();
            if (!trivias.isEmpty()) {
                int firstLineTrivia = SwitchCaseTooBigCheck.firstLineTrivia(trivias);
                if (firstLineTrivia == lastLabelLine) {
                    ++firstLineTrivia;
                }
                return Math.min(firstLineTrivia, firstStatementLine);
            }
            return firstStatementLine;
        }
        return Integer.MAX_VALUE;
    }

    private static int firstLineTrivia(List<SyntaxTrivia> trivias) {
        return trivias.get(0).startLine();
    }

    private void check(CaseLabelTree caseLabelTree, int caseStartLine, int nextCaseStartLine) {
        int lines = Math.max(nextCaseStartLine - caseStartLine, 1);
        if (lines > this.max) {
            this.reportIssue((Tree)caseLabelTree, "Reduce this switch case number of lines from " + lines + " to at most " + this.max + ", for example by extracting code into methods.");
        }
    }

    private static int getNextLine(SwitchStatementTree switchStatementTree, CaseGroupTree caseGroupTree) {
        int switchLastLine = SwitchCaseTooBigCheck.line((Tree)switchStatementTree.closeBraceToken());
        List cases = switchStatementTree.cases();
        int indexOfCaseGroup = cases.indexOf(caseGroupTree);
        if (indexOfCaseGroup == cases.size() - 1) {
            return switchLastLine;
        }
        return SwitchCaseTooBigCheck.line((Tree)cases.get(indexOfCaseGroup + 1));
    }

    private static int line(Tree tree) {
        return tree.firstToken().line();
    }
}

