/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.java.resolve.ParametrizedTypeJavaType;
import org.sonar.java.resolve.TypeVariableJavaType;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2112")
public class URLHashCodeAndEqualsCheck
extends IssuableSubscriptionVisitor {
    private static final String JAVA_NET_URL = "java.net.URL";
    private static final MethodMatcherCollection URL_MATCHERS = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{MethodMatcher.create().typeDefinition("java.net.URL").name("equals").addParameter("java.lang.Object"), MethodMatcher.create().typeDefinition("java.net.URL").name("hashCode").withoutParameter()});

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.VARIABLE, (Object)Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            Type variableType;
            VariableTree variableTree = (VariableTree)tree;
            if (variableTree.initializer() != null && URLHashCodeAndEqualsCheck.isSubTypeOfSetOrMap(variableType = variableTree.type().symbolType()) && URLHashCodeAndEqualsCheck.usesURLAsTypeParameter(variableType)) {
                this.reportIssue((Tree)variableTree.type(), "Use the URI class instead.");
            }
        } else if (this.hasSemantic() && URL_MATCHERS.anyMatch((MethodInvocationTree)tree)) {
            this.reportIssue(tree, "Use the URI class instead.");
        }
    }

    private static boolean isSubTypeOfSetOrMap(Type type) {
        return type.isSubtypeOf("java.util.Set") || type.isSubtypeOf("java.util.Map");
    }

    private static boolean usesURLAsTypeParameter(Type type) {
        Type firstTypeParameter = URLHashCodeAndEqualsCheck.getFirstTypeParameter(type);
        return firstTypeParameter != null && firstTypeParameter.is(JAVA_NET_URL);
    }

    @CheckForNull
    private static Type getFirstTypeParameter(Type type) {
        ParametrizedTypeJavaType parametrizedTypeType;
        Iterator iterator;
        if (type instanceof ParametrizedTypeJavaType && (iterator = (parametrizedTypeType = (ParametrizedTypeJavaType)type).typeParameters().iterator()).hasNext()) {
            TypeVariableJavaType variableType = (TypeVariableJavaType)iterator.next();
            return parametrizedTypeType.substitution(variableType);
        }
        return null;
    }
}

