/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractInSynchronizeChecker;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2273")
public class WaitInSynchronizeCheck
extends AbstractInSynchronizeChecker {
    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (!this.isInSyncBlock()) {
            String lockName;
            IdentifierTree methodName;
            if (mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                MemberSelectExpressionTree mse = (MemberSelectExpressionTree)mit.methodSelect();
                methodName = mse.identifier();
                lockName = mse.expression().symbolType().name();
            } else {
                methodName = (IdentifierTree)mit.methodSelect();
                lockName = "this";
            }
            this.reportIssue((Tree)methodName, "Make this call to \"" + methodName + "()\" only inside a synchronized block to be sure to hold the monitor on \"" + lockName + "\" object.");
        }
    }

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.builder().add((Object)MethodMatcher.create().name("wait").withoutParameter()).add((Object)MethodMatcher.create().name("wait").addParameter("long")).add((Object)MethodMatcher.create().name("wait").addParameter("long").addParameter("int")).add((Object)MethodMatcher.create().name("notify").withoutParameter()).add((Object)MethodMatcher.create().name("notifyAll").withoutParameter()).build();
    }
}

