/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.unused;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.RspecKey;
import org.sonar.java.checks.serialization.SerializableContract;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="UnusedPrivateMethod")
@RspecKey(value="S1144")
public class UnusedPrivateMethodCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD, (Object)Tree.Kind.CONSTRUCTOR);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        MethodTree node = (MethodTree)tree;
        Symbol.MethodSymbol symbol = node.symbol();
        if (node.modifiers().annotations().isEmpty() && symbol.isPrivate() && symbol.usages().isEmpty()) {
            if (node.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR})) {
                if (!node.parameters().isEmpty()) {
                    this.reportIssue((Tree)node.simpleName(), "Remove this unused private \"" + node.simpleName().name() + "\" constructor.");
                }
            } else if (!SerializableContract.SERIALIZABLE_CONTRACT_METHODS.contains(symbol.name())) {
                this.reportIssue((Tree)node.simpleName(), "Remove this unused private \"" + symbol.name() + "\" method.");
            }
        }
    }
}

