/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.xml.struts;

import com.google.common.collect.Iterables;
import java.util.LinkedList;
import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.xml.XPathXmlCheck;
import org.sonar.java.xml.XmlCheckContext;
import org.sonar.plugins.java.api.JavaCheck;
import org.w3c.dom.Node;

@Rule(key="S3373")
public class ActionNumberCheck
extends XPathXmlCheck {
    private static final int DEFAULT_MAXIMUM_NUMBER_FORWARDS = 4;
    @RuleProperty(key="threshold", description="Maximum allowed number of ``<forward/>`` mappings in an ``<action>``", defaultValue="4")
    public int maximumForwards = 4;
    private XPathExpression actionsExpression;
    private XPathExpression forwardsFromActionExpression;

    public void precompileXPathExpressions(XmlCheckContext context) {
        this.actionsExpression = context.compile("struts-config/action-mappings/action");
        this.forwardsFromActionExpression = context.compile("forward");
    }

    public void scanFileWithXPathExpressions(XmlCheckContext context) {
        for (Node action : context.evaluateOnDocument(this.actionsExpression)) {
            Iterable extraForwards = Iterables.skip((Iterable)context.evaluate(this.forwardsFromActionExpression, action), (int)this.maximumForwards);
            if (Iterables.isEmpty((Iterable)extraForwards)) continue;
            LinkedList<XmlCheckContext.XmlDocumentLocation> secondaries = new LinkedList<XmlCheckContext.XmlDocumentLocation>();
            for (Node forward : extraForwards) {
                secondaries.add(new XmlCheckContext.XmlDocumentLocation("Move this forward to another action.", forward));
            }
            int cost = secondaries.size();
            int numberForward = this.maximumForwards + cost;
            String message = "Reduce the number of forwards in this action from " + numberForward + " to at most " + this.maximumForwards + ".";
            context.reportIssue((JavaCheck)this, action, message, secondaries, Integer.valueOf(cost));
        }
    }
}

