/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3631")
public class ArraysAsListOfPrimitiveToStreamCheck
extends AbstractMethodDetection {
    private static final MethodMatcher ARRAYS_AS_LIST = MethodMatcher.create().typeDefinition("java.util.Arrays").name("asList").withAnyParameters();

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodMatcher.create().callSite(TypeCriteria.is((String)"java.util.List")).name("stream").withoutParameter());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        MethodInvocationTree arrayAsListInvocation;
        ExpressionTree expression;
        ExpressionTree methodSelect = mit.methodSelect();
        if (methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && (expression = ((MemberSelectExpressionTree)methodSelect).expression()).is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && ARRAYS_AS_LIST.matches(arrayAsListInvocation = (MethodInvocationTree)expression) && ArraysAsListOfPrimitiveToStreamCheck.shouldUsePrimitiveStream(arrayAsListInvocation)) {
            this.reportIssue((Tree)arrayAsListInvocation.methodSelect(), "Use \"Arrays.stream\" instead of \"Arrays.asList\".");
        }
    }

    private static boolean shouldUsePrimitiveStream(MethodInvocationTree mit) {
        Set<Type> argumentTypes = ArraysAsListOfPrimitiveToStreamCheck.argumentTypes(mit.arguments());
        return argumentTypes.size() == 1 && ArraysAsListOfPrimitiveToStreamCheck.isPrimitiveTypeHandledByStream(argumentTypes.iterator().next());
    }

    private static Set<Type> argumentTypes(Arguments arguments) {
        return arguments.stream().map(ExpressionTree::symbolType).collect(Collectors.toSet());
    }

    private static boolean isPrimitiveTypeHandledByStream(Type type) {
        return type.isPrimitive(Type.Primitives.INT) || type.isPrimitive(Type.Primitives.DOUBLE) || type.isPrimitive(Type.Primitives.LONG);
    }
}

