/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.java.matcher.NameCriteria;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2699")
public class AssertionsInTestsCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String VERIFY = "verify";
    private static final String ASSERT_NAME = "assert";
    private static final TypeCriteria ORG_ASSERTJ_ASSERTIONS = TypeCriteria.is((String)"org.assertj.core.api.Assertions");
    private static final TypeCriteria ORG_ASSERTJ_FAIL = TypeCriteria.is((String)"org.assertj.core.api.Fail");
    private static final TypeCriteria IO_RESTASSURED = TypeCriteria.is((String)"io.restassured.response.ValidatableResponseOptions");
    private static final TypeCriteria ANY_TYPE = TypeCriteria.anyType();
    private static final NameCriteria ANY_NAME = NameCriteria.any();
    private static final NameCriteria STARTS_WITH_FAIL = NameCriteria.startsWith((String)"fail");
    private static final NameCriteria STARTS_WITH_ASSERT = NameCriteria.startsWith((String)"assert");
    private static final MethodMatcherCollection ASSERTION_INVOCATION_MATCHERS = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{AssertionsInTestsCheck.method("org.junit.Assert", STARTS_WITH_ASSERT).withAnyParameters(), AssertionsInTestsCheck.method("org.junit.Assert", STARTS_WITH_FAIL).withAnyParameters(), AssertionsInTestsCheck.method("org.junit.rules.ExpectedException", NameCriteria.startsWith((String)"expect")).withAnyParameters(), AssertionsInTestsCheck.method(TypeCriteria.subtypeOf((String)"junit.framework.Assert"), STARTS_WITH_ASSERT).withAnyParameters(), AssertionsInTestsCheck.method(TypeCriteria.subtypeOf((String)"junit.framework.Assert"), STARTS_WITH_FAIL).withAnyParameters(), AssertionsInTestsCheck.method("org.junit.rules.ErrorCollector", "checkThat").withAnyParameters(), AssertionsInTestsCheck.method(TypeCriteria.subtypeOf((String)"org.fest.assertions.GenericAssert"), ANY_NAME).withAnyParameters(), AssertionsInTestsCheck.method("org.fest.assertions.Assertions", STARTS_WITH_ASSERT).withAnyParameters(), AssertionsInTestsCheck.method("org.fest.assertions.Fail", STARTS_WITH_FAIL).withAnyParameters(), AssertionsInTestsCheck.method(TypeCriteria.subtypeOf((String)"org.fest.assertions.api.AbstractAssert"), ANY_NAME).withAnyParameters(), AssertionsInTestsCheck.method("org.fest.assertions.api.Fail", STARTS_WITH_FAIL).withAnyParameters(), AssertionsInTestsCheck.method(IO_RESTASSURED, NameCriteria.is((String)"body")).withAnyParameters(), AssertionsInTestsCheck.method(IO_RESTASSURED, NameCriteria.is((String)"time")).withAnyParameters(), AssertionsInTestsCheck.method(IO_RESTASSURED, NameCriteria.startsWith((String)"content")).withAnyParameters(), AssertionsInTestsCheck.method(IO_RESTASSURED, NameCriteria.startsWith((String)"status")).withAnyParameters(), AssertionsInTestsCheck.method(IO_RESTASSURED, NameCriteria.startsWith((String)"header")).withAnyParameters(), AssertionsInTestsCheck.method(IO_RESTASSURED, NameCriteria.startsWith((String)"cookie")).withAnyParameters(), AssertionsInTestsCheck.method(IO_RESTASSURED, NameCriteria.startsWith((String)"spec")).withAnyParameters(), AssertionsInTestsCheck.method(TypeCriteria.subtypeOf((String)"io.reactivex.observers.BaseTestConsumer"), STARTS_WITH_ASSERT).withAnyParameters(), AssertionsInTestsCheck.method(TypeCriteria.subtypeOf((String)"rx.observers.TestObserver"), STARTS_WITH_ASSERT).withAnyParameters(), AssertionsInTestsCheck.method(TypeCriteria.subtypeOf((String)"rx.observers.TestSubscriber"), STARTS_WITH_ASSERT).withAnyParameters(), AssertionsInTestsCheck.method(TypeCriteria.is((String)"rx.observers.AssertableSubscriber"), STARTS_WITH_ASSERT).withAnyParameters(), AssertionsInTestsCheck.method(TypeCriteria.subtypeOf((String)"org.assertj.core.api.AbstractAssert"), ANY_NAME).withAnyParameters(), AssertionsInTestsCheck.method(ORG_ASSERTJ_FAIL, STARTS_WITH_FAIL).withAnyParameters(), AssertionsInTestsCheck.method(ORG_ASSERTJ_FAIL, "shouldHaveThrown").withAnyParameters(), AssertionsInTestsCheck.method(ORG_ASSERTJ_ASSERTIONS, STARTS_WITH_FAIL).withAnyParameters(), AssertionsInTestsCheck.method(ORG_ASSERTJ_ASSERTIONS, "shouldHaveThrown").withAnyParameters(), AssertionsInTestsCheck.method(ORG_ASSERTJ_ASSERTIONS, STARTS_WITH_ASSERT).withAnyParameters(), AssertionsInTestsCheck.method(TypeCriteria.subtypeOf((String)"org.assertj.core.api.AbstractSoftAssertions"), STARTS_WITH_ASSERT).withAnyParameters(), AssertionsInTestsCheck.method("org.hamcrest.MatcherAssert", STARTS_WITH_ASSERT).withAnyParameters(), AssertionsInTestsCheck.method("org.mockito.Mockito", NameCriteria.startsWith((String)"verify")).withAnyParameters(), AssertionsInTestsCheck.method("org.mockito.InOrder", NameCriteria.startsWith((String)"verify")).withAnyParameters(), AssertionsInTestsCheck.method("org.springframework.test.web.servlet.ResultActions", "andExpect").addParameter(ANY_TYPE), AssertionsInTestsCheck.method("org.easymock.EasyMock", "verify").withAnyParameters(), AssertionsInTestsCheck.method(TypeCriteria.subtypeOf((String)"org.easymock.IMocksControl"), "verify").withAnyParameters(), AssertionsInTestsCheck.method(TypeCriteria.subtypeOf((String)"org.easymock.EasyMockSupport"), "verifyAll").withAnyParameters(), AssertionsInTestsCheck.method("com.google.common.truth.Truth", STARTS_WITH_ASSERT).withAnyParameters(), AssertionsInTestsCheck.method("com.google.common.truth.Truth8", STARTS_WITH_ASSERT).withAnyParameters(), AssertionsInTestsCheck.method(TypeCriteria.subtypeOf((String)"org.jmock.Mockery"), "assertIsSatisfied").withAnyParameters(), AssertionsInTestsCheck.method("com.github.tomakehurst.wiremock.client.WireMock", "verify").withAnyParameters(), AssertionsInTestsCheck.method("com.github.tomakehurst.wiremock.WireMockServer", "verify").withAnyParameters(), AssertionsInTestsCheck.method("io.vertx.ext.unit.TestContext", STARTS_WITH_ASSERT).withAnyParameters(), AssertionsInTestsCheck.method("io.vertx.ext.unit.TestContext", STARTS_WITH_FAIL).withAnyParameters()});
    private final Deque<Boolean> methodContainsAssertion = new ArrayDeque<Boolean>();
    private final Deque<Boolean> inUnitTest = new ArrayDeque<Boolean>();
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.inUnitTest.push(false);
        this.methodContainsAssertion.push(false);
        this.scan((Tree)context.getTree());
        this.methodContainsAssertion.pop();
        this.inUnitTest.pop();
    }

    public void visitMethod(MethodTree methodTree) {
        if (ModifiersUtils.hasModifier((ModifiersTree)methodTree.modifiers(), (Modifier)Modifier.ABSTRACT)) {
            return;
        }
        boolean isUnitTest = AssertionsInTestsCheck.isUnitTest(methodTree);
        this.inUnitTest.push(isUnitTest);
        this.methodContainsAssertion.push(false);
        super.visitMethod(methodTree);
        Boolean containsAssertion = this.methodContainsAssertion.pop();
        this.inUnitTest.pop();
        if (isUnitTest && !AssertionsInTestsCheck.expectAssertion(methodTree) && !containsAssertion.booleanValue()) {
            this.context.reportIssue((JavaCheck)this, (Tree)methodTree.simpleName(), "Add at least one assertion to this test case.");
        }
    }

    public void visitMethodInvocation(MethodInvocationTree mit) {
        super.visitMethodInvocation(mit);
        if (!this.methodContainsAssertion.peek().booleanValue() && this.inUnitTest.peek().booleanValue() && ASSERTION_INVOCATION_MATCHERS.anyMatch(mit)) {
            this.methodContainsAssertion.pop();
            this.methodContainsAssertion.push(true);
        }
    }

    public void visitMethodReference(MethodReferenceTree methodReferenceTree) {
        super.visitMethodReference(methodReferenceTree);
        if (!this.methodContainsAssertion.peek().booleanValue() && this.inUnitTest.peek().booleanValue() && ASSERTION_INVOCATION_MATCHERS.anyMatch(methodReferenceTree)) {
            this.methodContainsAssertion.pop();
            this.methodContainsAssertion.push(true);
        }
    }

    private static boolean expectAssertion(MethodTree methodTree) {
        List annotationValues = methodTree.symbol().metadata().valuesForAnnotation("org.junit.Test");
        if (annotationValues != null) {
            for (SymbolMetadata.AnnotationValue annotationValue : annotationValues) {
                if (!"expected".equals(annotationValue.name())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isUnitTest(MethodTree methodTree) {
        for (Symbol.MethodSymbol symbol = methodTree.symbol(); symbol != null; symbol = symbol.overriddenSymbol()) {
            if (!symbol.metadata().isAnnotatedWith("org.junit.Test")) continue;
            return true;
        }
        Symbol.TypeSymbol enclosingClass = methodTree.symbol().enclosingClass();
        return enclosingClass != null && enclosingClass.type().isSubtypeOf("junit.framework.TestCase") && methodTree.simpleName().name().startsWith("test");
    }

    private static MethodMatcher method(String typeDefinition, String methodName) {
        return AssertionsInTestsCheck.method(TypeCriteria.is((String)typeDefinition), NameCriteria.is((String)methodName));
    }

    private static MethodMatcher method(TypeCriteria typeDefinitionCriteria, String methodName) {
        return AssertionsInTestsCheck.method(typeDefinitionCriteria, NameCriteria.is((String)methodName));
    }

    private static MethodMatcher method(String typeDefinition, NameCriteria nameCriteria) {
        return MethodMatcher.create().typeDefinition(TypeCriteria.is((String)typeDefinition)).name(nameCriteria);
    }

    private static MethodMatcher method(TypeCriteria typeDefinitionCriteria, NameCriteria nameCriteria) {
        return MethodMatcher.create().typeDefinition(typeDefinitionCriteria).name(nameCriteria);
    }
}

