/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2718")
public class DateUtilsTruncateCheck
extends AbstractMethodDetection
implements JavaVersionAwareVisitor {
    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava8Compatible();
    }

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)DateUtilsTruncateCheck.truncateMethodMatcher("java.util.Date"), (Object)DateUtilsTruncateCheck.truncateMethodMatcher("java.util.Calendar"), (Object)DateUtilsTruncateCheck.truncateMethodMatcher("java.lang.Object"));
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), "Use \"ZonedDateTime.truncatedTo\" instead." + this.context.getJavaVersion().java8CompatibilityMessage());
    }

    private static MethodMatcher truncateMethodMatcher(String firstParameterType) {
        return MethodMatcher.create().typeDefinition("org.apache.commons.lang.time.DateUtils").name("truncate").addParameter(firstParameterType).addParameter("int");
    }
}

