/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S3052")
public class DefaultInitializedFieldCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS, (Object)Tree.Kind.ENUM);
    }

    public void visitNode(Tree tree) {
        List members = ((ClassTree)tree).members();
        for (Tree member : members) {
            if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) continue;
            this.checkVariable((VariableTree)member);
        }
    }

    private void checkVariable(VariableTree member) {
        if (ModifiersUtils.hasModifier((ModifiersTree)member.modifiers(), (Modifier)Modifier.FINAL)) {
            return;
        }
        ExpressionTree initializer = member.initializer();
        if (initializer != null && DefaultInitializedFieldCheck.isDefault(initializer = ExpressionUtils.skipParentheses((ExpressionTree)initializer), member.type().symbolType().isPrimitive())) {
            this.reportIssue((Tree)initializer, "Remove this initialization to \"" + ((LiteralTree)initializer).value() + "\", the compiler will do that for you.");
        }
    }

    private static boolean isDefault(ExpressionTree expression, boolean isPrimitive) {
        if (!isPrimitive) {
            return expression.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL});
        }
        switch (expression.kind()) {
            case CHAR_LITERAL: {
                String charValue = ((LiteralTree)expression).value();
                return "'\\u0000'".equals(charValue) || "'\\0'".equals(charValue);
            }
            case BOOLEAN_LITERAL: {
                return LiteralUtils.isFalse((Tree)expression);
            }
            case INT_LITERAL: 
            case LONG_LITERAL: {
                Long value = LiteralUtils.longLiteralValue((ExpressionTree)expression);
                return value != null && value == 0L;
            }
            case FLOAT_LITERAL: 
            case DOUBLE_LITERAL: {
                return Double.doubleToLongBits(Double.valueOf(((LiteralTree)expression).value())) == 0L;
            }
        }
        return false;
    }
}

