/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.IllegalRuleParameterException;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S3688")
public class DisallowedClassCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    @RuleProperty(key="className", description="Fully qualified name of the forbidden class. Use a regex to forbid a package.", defaultValue="")
    public String disallowedClass = "";
    private Pattern pattern = null;
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        if (context.getSemanticModel() != null) {
            this.scan((Tree)context.getTree());
        }
    }

    public void visitImport(ImportTree tree) {
        int separator;
        String importName = ExpressionsHelper.concatenate((ExpressionTree)tree.qualifiedIdentifier());
        if (!this.checkIfDisallowed(importName, tree.qualifiedIdentifier()) && (separator = importName.lastIndexOf(46)) != -1) {
            this.checkIfDisallowed(importName.substring(0, separator), tree.qualifiedIdentifier());
        }
        super.visitImport(tree);
    }

    public void visitMethodInvocation(MethodInvocationTree tree) {
        if (tree.symbol().isMethodSymbol()) {
            String className = tree.symbol().owner().type().fullyQualifiedName();
            this.checkIfDisallowed(className, (Tree)tree.methodSelect());
        }
        super.visitMethodInvocation(tree);
    }

    public void visitVariable(VariableTree variableTree) {
        String variableTypeName = variableTree.type().symbolType().fullyQualifiedName();
        this.checkIfDisallowed(variableTypeName, (Tree)variableTree.type());
        super.visitVariable(variableTree);
    }

    public void visitMethod(MethodTree methodTree) {
        if (methodTree.returnType() != null) {
            String returnTypeName = methodTree.returnType().symbolType().fullyQualifiedName();
            this.checkIfDisallowed(returnTypeName, (Tree)methodTree.returnType());
        }
        super.visitMethod(methodTree);
    }

    public void visitNewClass(NewClassTree newClassTree) {
        String newClassTypeName = newClassTree.identifier().symbolType().fullyQualifiedName();
        Tree parent = newClassTree.parent();
        if (parent != null && !parent.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            this.checkIfDisallowed(newClassTypeName, (Tree)newClassTree);
        }
        super.visitNewClass(newClassTree);
    }

    public void visitClass(ClassTree classTree) {
        TypeTree superClass = classTree.superClass();
        if (superClass != null) {
            String superClassTypeName = superClass.symbolType().fullyQualifiedName();
            this.checkIfDisallowed(superClassTypeName, (Tree)superClass);
        }
        super.visitClass(classTree);
    }

    public void visitAnnotation(AnnotationTree annotationTree) {
        String annotationTypeName = annotationTree.symbolType().fullyQualifiedName();
        this.checkIfDisallowed(annotationTypeName, (Tree)annotationTree.annotationType());
        super.visitAnnotation(annotationTree);
    }

    private boolean checkIfDisallowed(String className, Tree tree) {
        if (this.pattern == null) {
            try {
                this.pattern = Pattern.compile(this.disallowedClass);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalRuleParameterException("[" + ((Object)((Object)this)).getClass().getSimpleName() + "] Unable to compile the regular expression: " + this.disallowedClass, (Throwable)e);
            }
        }
        if (this.pattern.matcher(className).matches() && !tree.is(new Tree.Kind[]{Tree.Kind.INFERED_TYPE})) {
            this.context.reportIssue((JavaCheck)this, tree, "Remove the use of this forbidden class.");
            return true;
        }
        return false;
    }
}

