/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2253")
public class DisallowedMethodCheck
extends AbstractMethodDetection {
    @RuleProperty(key="className", description="Name of the class whose method is forbidden")
    private String className = "";
    @RuleProperty(key="methodName", description="Name of the forbidden method")
    private String methodName = "";
    @RuleProperty(key="argumentTypes", description="Comma-delimited list of argument types, E.G. java.lang.String, int[], int")
    private String argumentTypes = "";
    @RuleProperty(key="allOverloads", description="Set to true to flag all overloads regardless of parameter type", defaultValue="false")
    private boolean allOverloads = false;

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        if (StringUtils.isEmpty((String)this.methodName)) {
            return ImmutableList.of();
        }
        MethodMatcher invocationMatcher = MethodMatcher.create().name(this.methodName);
        if (StringUtils.isNotEmpty((String)this.className)) {
            invocationMatcher.typeDefinition(this.className);
        }
        if (this.allOverloads) {
            invocationMatcher.withAnyParameters();
        } else {
            String[] args = StringUtils.split((String)this.argumentTypes, (String)",");
            if (args.length == 0) {
                invocationMatcher.withoutParameter();
            } else {
                for (String arg : args) {
                    invocationMatcher.addParameter(StringUtils.trim((String)arg));
                }
            }
        }
        return ImmutableList.of((Object)invocationMatcher);
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), "Remove this forbidden call");
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setArgumentTypes(String argumentTypes) {
        this.argumentTypes = argumentTypes;
    }

    public void setAllOverloads(boolean allOverloads) {
        this.allOverloads = allOverloads;
    }
}

