/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.RspecKey;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S00108")
@RspecKey(value="S108")
public class EmptyBlockCheck
extends IssuableSubscriptionVisitor {
    private static final String MESSAGE = "Either remove or fill this block of code.";
    private boolean isMethodBlock;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD, (Object)Tree.Kind.CONSTRUCTOR, (Object)Tree.Kind.BLOCK, (Object)Tree.Kind.INITIALIZER, (Object)Tree.Kind.STATIC_INITIALIZER, (Object)Tree.Kind.SWITCH_STATEMENT);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.SWITCH_STATEMENT})) {
            SwitchStatementTree switchStatementTree = (SwitchStatementTree)tree;
            if (switchStatementTree.cases().isEmpty()) {
                this.reportIssue((Tree)switchStatementTree.openBraceToken(), MESSAGE);
            }
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD}) || tree.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR})) {
            this.isMethodBlock = true;
        } else if (this.isMethodBlock) {
            this.isMethodBlock = false;
        } else if (!(tree.parent().is(new Tree.Kind[]{Tree.Kind.LAMBDA_EXPRESSION}) || EmptyBlockCheck.hasStatements((BlockTree)tree) || EmptyBlockCheck.isRuleException((BlockTree)tree))) {
            this.reportIssue((Tree)((BlockTree)tree).openBraceToken(), MESSAGE);
        }
    }

    private static boolean isRuleException(BlockTree tree) {
        return EmptyBlockCheck.hasCommentInside(tree) && !tree.parent().is(new Tree.Kind[]{Tree.Kind.SYNCHRONIZED_STATEMENT});
    }

    private static boolean hasCommentInside(BlockTree tree) {
        return tree.closeBraceToken() == null || !tree.closeBraceToken().trivias().isEmpty();
    }

    private static boolean hasStatements(BlockTree tree) {
        return !tree.body().isEmpty();
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD}) || tree.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR})) {
            this.isMethodBlock = false;
        }
    }
}

