/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2973")
public class EscapedUnicodeCharactersCheck
extends IssuableSubscriptionVisitor {
    private static final Pattern UNICODE_ESCAPED_CHAR = Pattern.compile("\\\\u+[a-fA-F0-9]{4}");
    private static final Predicate<String> IS_PRINTABLE_ESCAPED_UNICODE = input -> {
        int unicodePointDecimal = Integer.parseInt(input.substring(input.length() - 4), 16);
        return 31 < unicodePointDecimal && unicodePointDecimal < 127 || 160 < unicodePointDecimal;
    };

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.STRING_LITERAL);
    }

    public void visitNode(Tree node) {
        if (LiteralUtils.isEmptyString((Tree)node)) {
            return;
        }
        String value = LiteralUtils.trimQuotes((String)((LiteralTree)node).value());
        Matcher matcher = UNICODE_ESCAPED_CHAR.matcher(value.replaceAll("\\\\\\\\", ""));
        List<String> matches = EscapedUnicodeCharactersCheck.getAllMatches(matcher);
        if (!matches.isEmpty()) {
            boolean notOnlyUnicodeEscaped;
            boolean bl = notOnlyUnicodeEscaped = !matcher.replaceAll("").isEmpty();
            if (notOnlyUnicodeEscaped && matches.stream().anyMatch(IS_PRINTABLE_ESCAPED_UNICODE)) {
                this.reportIssue(node, "Remove this Unicode escape sequence and use the character instead.");
            }
        }
    }

    private static List<String> getAllMatches(Matcher matcher) {
        ArrayList<String> matches = new ArrayList<String>();
        while (matcher.find()) {
            matches.add(matcher.group());
        }
        return matches;
    }
}

