/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S1849")
public class HasNextCallingNextCheck
extends IssuableSubscriptionVisitor {
    private HasNextBodyVisitor hasNextBodyVisitor = new HasNextBodyVisitor();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (!this.hasSemantic()) {
            return;
        }
        if (methodTree.block() != null && HasNextCallingNextCheck.isHasNextMethod(methodTree)) {
            this.hasNextBodyVisitor.setHasNextOwner(methodTree.symbol().owner());
            methodTree.block().accept((TreeVisitor)this.hasNextBodyVisitor);
        }
    }

    private static boolean isHasNextMethod(MethodTree methodTree) {
        return "hasNext".equals(methodTree.simpleName().name()) && methodTree.parameters().isEmpty() && HasNextCallingNextCheck.isIteratorMethod((Symbol)methodTree.symbol());
    }

    private static boolean isIteratorMethod(Symbol method) {
        Type type = method.owner().enclosingClass().type();
        return !type.is("java.util.Iterator") && type.isSubtypeOf("java.util.Iterator");
    }

    private class HasNextBodyVisitor
    extends BaseTreeVisitor {
        private Symbol hasNextOwner;

        private HasNextBodyVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            Symbol method = tree.symbol();
            if ("next".equals(method.name()) && tree.arguments().isEmpty() && HasNextCallingNextCheck.isIteratorMethod(method) && (this.hasNextOwner == method.owner() || this.hasNextOwner.type().isSubtypeOf(method.owner().type()))) {
                HasNextCallingNextCheck.this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)tree), "Refactor the implementation of this \"Iterator.hasNext()\" method to not call \"Iterator.next()\".");
            }
            super.visitMethodInvocation(tree);
        }

        public void setHasNextOwner(Symbol hasNextOwner) {
            this.hasNextOwner = hasNextOwner;
        }

        public void visitClass(ClassTree tree) {
        }
    }
}

