/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2089")
public class HttpRefererCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodMatcher.create().typeDefinition("javax.servlet.http.HttpServletRequest").name("getHeader").addParameter("java.lang.String"));
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        LiteralTree lt;
        ExpressionTree arg = (ExpressionTree)mit.arguments().get(0);
        if (arg.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) && "\"referer\"".equals((lt = (LiteralTree)arg).value())) {
            this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), "\"referer\" header should not be relied on");
        }
    }
}

