/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1764")
public class IdenticalOperandOnBinaryExpressionCheck
extends IssuableSubscriptionVisitor {
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private static final MethodMatcher EQUALS_MATCHER = MethodMatcher.create().typeDefinition("java.lang.Object").name("equals").addParameter("java.lang.Object");
    private static final MethodMatcher DEEP_EQUALS_MATCHER = MethodMatcher.create().typeDefinition("java.util.Objects").name("equals").addParameter("java.lang.Object").addParameter("java.lang.Object");
    private static final MethodMatcher OBJECTS_EQUALS_MATCHER = MethodMatcher.create().typeDefinition("java.util.Objects").name("deepEquals").addParameter("java.lang.Object").addParameter("java.lang.Object");
    private static final List<Tree.Kind> SYMMETRIC_OPERATORS = ImmutableList.builder().add((Object)Tree.Kind.EQUAL_TO).add((Object)Tree.Kind.NOT_EQUAL_TO).add((Object)Tree.Kind.AND).add((Object)Tree.Kind.XOR).add((Object)Tree.Kind.OR).add((Object)Tree.Kind.CONDITIONAL_AND).add((Object)Tree.Kind.CONDITIONAL_OR).build();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.builder().add((Object)Tree.Kind.DIVIDE).add((Object)Tree.Kind.REMAINDER).add((Object)Tree.Kind.MINUS).add((Object)Tree.Kind.LEFT_SHIFT).add((Object)Tree.Kind.RIGHT_SHIFT).add((Object)Tree.Kind.UNSIGNED_RIGHT_SHIFT).add((Object)Tree.Kind.LESS_THAN).add((Object)Tree.Kind.GREATER_THAN).add((Object)Tree.Kind.LESS_THAN_OR_EQUAL_TO).add((Object)Tree.Kind.GREATER_THAN_OR_EQUAL_TO).add((Object)Tree.Kind.EQUAL_TO).add((Object)Tree.Kind.NOT_EQUAL_TO).add((Object)Tree.Kind.AND).add((Object)Tree.Kind.XOR).add((Object)Tree.Kind.OR).add((Object)Tree.Kind.CONDITIONAL_AND).add((Object)Tree.Kind.CONDITIONAL_OR).add((Object)Tree.Kind.METHOD_INVOCATION).build();
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree mit = (MethodInvocationTree)tree;
            this.checkEqualsMethods(mit);
            return;
        }
        BinaryExpressionTree binaryExpressionTree = (BinaryExpressionTree)tree;
        ExpressionTree rightOperand = binaryExpressionTree.rightOperand();
        ExpressionTree equivalentOperand = IdenticalOperandOnBinaryExpressionCheck.equivalentOperand(binaryExpressionTree, rightOperand);
        if (equivalentOperand != null) {
            this.reportIssue((Tree)rightOperand, "Correct one of the identical sub-expressions on both sides of operator \"" + binaryExpressionTree.operatorToken().text() + "\"", (List)ImmutableList.of((Object)new JavaFileScannerContext.Location("", (Tree)equivalentOperand)), null);
        }
    }

    private void checkEqualsMethods(MethodInvocationTree mit) {
        ExpressionTree rightOp;
        ExpressionTree leftOp;
        if (EQUALS_MATCHER.matches(mit)) {
            ExpressionTree rightOp2;
            ExpressionTree leftOp2;
            if (mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && SyntacticEquivalence.areEquivalent((Tree)(leftOp2 = ((MemberSelectExpressionTree)mit.methodSelect()).expression()), (Tree)(rightOp2 = (ExpressionTree)mit.arguments().get(0)))) {
                this.reportIssue((Tree)rightOp2, "Correct one of the identical sub-expressions on both sides of equals.", (List)ImmutableList.of((Object)new JavaFileScannerContext.Location("", (Tree)leftOp2)), null);
            }
        } else if ((DEEP_EQUALS_MATCHER.matches(mit) || OBJECTS_EQUALS_MATCHER.matches(mit)) && SyntacticEquivalence.areEquivalent((Tree)(leftOp = (ExpressionTree)mit.arguments().get(0)), (Tree)(rightOp = (ExpressionTree)mit.arguments().get(1)))) {
            this.reportIssue((Tree)rightOp, "Correct one of the identical argument sub-expressions.", (List)ImmutableList.of((Object)new JavaFileScannerContext.Location("", (Tree)leftOp)), null);
        }
    }

    @CheckForNull
    public static ExpressionTree equivalentOperand(BinaryExpressionTree tree, ExpressionTree rightOperand) {
        if (IdenticalOperandOnBinaryExpressionCheck.isNanTest(tree) || IdenticalOperandOnBinaryExpressionCheck.isLeftShiftOnOne(tree)) {
            return null;
        }
        return IdenticalOperandOnBinaryExpressionCheck.equivalentOperand(tree.leftOperand(), rightOperand, tree.kind());
    }

    public static ExpressionTree equivalentOperand(ExpressionTree left, ExpressionTree right, Tree.Kind binaryKind) {
        if (SyntacticEquivalence.areEquivalent((Tree)left, (Tree)right)) {
            return left;
        }
        if (SYMMETRIC_OPERATORS.contains(binaryKind) && left.is(new Tree.Kind[]{binaryKind})) {
            ExpressionTree equivalent = IdenticalOperandOnBinaryExpressionCheck.equivalentOperand(((BinaryExpressionTree)left).leftOperand(), right, binaryKind);
            if (equivalent != null) {
                return equivalent;
            }
            return IdenticalOperandOnBinaryExpressionCheck.equivalentOperand(((BinaryExpressionTree)left).rightOperand(), right, binaryKind);
        }
        return null;
    }

    private static boolean isNanTest(BinaryExpressionTree tree) {
        Type leftOperandType = tree.leftOperand().symbolType();
        return tree.is(new Tree.Kind[]{Tree.Kind.NOT_EQUAL_TO}) && (leftOperandType.isPrimitive(Type.Primitives.FLOAT) || leftOperandType.isPrimitive(Type.Primitives.DOUBLE));
    }

    private static boolean isLeftShiftOnOne(BinaryExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.LEFT_SHIFT}) && tree.leftOperand().is(new Tree.Kind[]{Tree.Kind.INT_LITERAL}) && tree.rightOperand().is(new Tree.Kind[]{Tree.Kind.INT_LITERAL})) {
            String left = ((LiteralTree)tree.leftOperand()).value();
            String right = ((LiteralTree)tree.rightOperand()).value();
            if ("1".equals(right) && "1".equals(left)) {
                return true;
            }
        }
        return false;
    }
}

