/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S126")
public class IfElseIfStatementEndsWithElseCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.IF_STATEMENT);
    }

    public void visitNode(Tree tree) {
        IfStatementTree ifStmt;
        IfStatementTree treeIfStmt = (IfStatementTree)tree;
        StatementTree elseStmt = treeIfStmt.elseStatement();
        if (elseStmt != null && elseStmt.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT}) && (ifStmt = (IfStatementTree)elseStmt).elseStatement() == null) {
            this.reportIssue((Tree)treeIfStmt.elseKeyword(), (Tree)ifStmt.ifKeyword(), "\"if ... else if\" constructs should end with \"else\" clauses.");
        }
    }
}

