/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;

@Rule(key="S2110")
public class InvalidDateValuesCheck
extends AbstractMethodDetection {
    public static final String JAVA_UTIL_CALENDAR = "java.util.Calendar";
    public static final String JAVA_UTIL_DATE = "java.util.Date";
    public static final String JAVA_SQL_DATE = "java.sql.Date";
    private static final String[] GREGORIAN_PARAMETERS = new String[]{"year", "month", "dayOfMonth", "hourOfDay", "minute", "second"};
    private static final String[] DATE_GET_METHODS = new String[]{"getDate", "getMonth", "getHours", "getMinutes", "getSeconds"};
    private static final String[] DATE_SET_METHODS = new String[]{"setDate", "setMonth", "setHours", "setMinutes", "setSeconds"};
    private static final List<MethodMatcher> DATE_METHODS_COMPARISON = ImmutableList.builder().add((Object)MethodMatcher.create().typeDefinition("java.util.Calendar").name("get").addParameter("int")).addAll(InvalidDateValuesCheck.dateGetMatchers()).build();

    private static List<MethodMatcher> dateGetMatchers() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String dateGetMethod : DATE_GET_METHODS) {
            builder.add((Object)InvalidDateValuesCheck.dateMethodInvocationMatcherGetter(JAVA_UTIL_DATE, dateGetMethod));
            builder.add((Object)InvalidDateValuesCheck.dateMethodInvocationMatcherGetter(JAVA_SQL_DATE, dateGetMethod));
        }
        return builder.build();
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.builder().addAll(super.nodesToVisit()).add((Object)Tree.Kind.EQUAL_TO).add((Object)Tree.Kind.NOT_EQUAL_TO).build();
    }

    @Override
    public void visitNode(Tree tree) {
        super.visitNode(tree);
        if (this.hasSemantic() && tree.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO})) {
            BinaryExpressionTree binaryExpressionTree = (BinaryExpressionTree)tree;
            String name = InvalidDateValuesCheck.getThresholdToCheck(binaryExpressionTree.leftOperand());
            ExpressionTree argToCheck = null;
            if (name == null) {
                name = InvalidDateValuesCheck.getThresholdToCheck(binaryExpressionTree.rightOperand());
                if (name != null) {
                    argToCheck = binaryExpressionTree.leftOperand();
                }
            } else {
                argToCheck = binaryExpressionTree.rightOperand();
            }
            if (argToCheck != null) {
                this.checkArgument(argToCheck, name, "\"{0}\" is not a valid value for \"{1}\".");
            }
        }
    }

    @CheckForNull
    private static String getThresholdToCheck(ExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree mit = (MethodInvocationTree)tree;
            String name = InvalidDateValuesCheck.getMethodName(mit);
            for (MethodMatcher methodInvocationMatcher : DATE_METHODS_COMPARISON) {
                if (!methodInvocationMatcher.matches(mit)) continue;
                return InvalidDateValuesCheck.getName(mit, name);
            }
        }
        return null;
    }

    @CheckForNull
    private static String getName(MethodInvocationTree mit, String name) {
        if ("get".equals(name)) {
            return InvalidDateValuesCheck.getReferencedCalendarName((ExpressionTree)mit.arguments().get(0));
        }
        return name;
    }

    @CheckForNull
    private static String getReferencedCalendarName(ExpressionTree argument) {
        Symbol reference = null;
        if (argument.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            reference = ((MemberSelectExpressionTree)argument).identifier().symbol();
        } else if (argument.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            reference = ((IdentifierTree)argument).symbol();
        }
        if (reference != null && reference.owner().type().is(JAVA_UTIL_CALENDAR) && Threshold.getThreshold(reference.name()) != null) {
            return reference.name();
        }
        return null;
    }

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String dateSetMethod : DATE_SET_METHODS) {
            builder.add((Object)InvalidDateValuesCheck.dateMethodInvocationMatcherSetter(JAVA_UTIL_DATE, dateSetMethod));
            builder.add((Object)InvalidDateValuesCheck.dateMethodInvocationMatcherSetter(JAVA_SQL_DATE, dateSetMethod));
        }
        return builder.add((Object)MethodMatcher.create().typeDefinition(JAVA_UTIL_CALENDAR).name("set").addParameter("int").addParameter("int")).add((Object)MethodMatcher.create().typeDefinition("java.util.GregorianCalendar").name("<init>").withAnyParameters()).build();
    }

    private static MethodMatcher dateMethodInvocationMatcherGetter(String type, String methodName) {
        return MethodMatcher.create().typeDefinition(type).name(methodName).withoutParameter();
    }

    private static MethodMatcher dateMethodInvocationMatcherSetter(String type, String methodName) {
        return MethodMatcher.create().typeDefinition(type).name(methodName).addParameter("int");
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        String name = InvalidDateValuesCheck.getMethodName(mit);
        Arguments arguments = mit.arguments();
        if ("set".equals(name)) {
            ExpressionTree arg0 = (ExpressionTree)arguments.get(0);
            ExpressionTree arg1 = (ExpressionTree)arguments.get(1);
            String referenceName = InvalidDateValuesCheck.getReferencedCalendarName(arg0);
            if (referenceName != null) {
                this.checkArgument(arg1, referenceName, "\"{0}\" is not a valid value for setting \"{1}\".");
            }
        } else if ("<init>".equals(mit.symbol().name())) {
            this.checkConstructorArguments(mit.arguments());
        } else {
            this.checkArgument((ExpressionTree)arguments.get(0), name, "\"{0}\" is not a valid value for \"{1}\" method.");
        }
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        this.checkConstructorArguments(newClassTree.arguments());
    }

    private void checkConstructorArguments(Arguments arguments) {
        int numberArgsToCheck = Math.min(arguments.size(), GREGORIAN_PARAMETERS.length);
        for (int i = 1; i < numberArgsToCheck; ++i) {
            this.checkArgument((ExpressionTree)arguments.get(i), GREGORIAN_PARAMETERS[i], "\"{0}\" is not a valid value for setting \"{1}\".");
        }
    }

    private void checkArgument(ExpressionTree arg, String name, String message) {
        int argValue;
        LiteralTree literal = null;
        int sign = 1;
        if (arg.is(new Tree.Kind[]{Tree.Kind.INT_LITERAL})) {
            literal = (LiteralTree)arg;
        } else if (arg.is(new Tree.Kind[]{Tree.Kind.UNARY_MINUS, Tree.Kind.UNARY_PLUS}) && ((UnaryExpressionTree)arg).expression().is(new Tree.Kind[]{Tree.Kind.INT_LITERAL})) {
            if (arg.is(new Tree.Kind[]{Tree.Kind.UNARY_MINUS})) {
                sign = -1;
            }
            literal = (LiteralTree)((UnaryExpressionTree)arg).expression();
        }
        if (literal != null && ((argValue = Integer.parseInt(literal.value()) * sign) > Threshold.getThreshold(name) || argValue < 0)) {
            this.reportIssue((Tree)arg, MessageFormat.format(message, argValue, name));
        }
    }

    private static String getMethodName(MethodInvocationTree mit) {
        return ExpressionUtils.methodName((MethodInvocationTree)mit).name();
    }

    private static enum Threshold {
        MONTH(11, "setMonth", "getMonth", "MONTH", "month"),
        DATE(31, "setDate", "getDate", "DAY_OF_MONTH", "dayOfMonth"),
        HOURS(23, "setHours", "getHours", "HOUR_OF_DAY", "hourOfDay"),
        MINUTE(60, "setMinutes", "getMinutes", "MINUTE", "minute"),
        SECOND(61, "setSeconds", "getSeconds", "SECOND", "second");

        private static Map<String, Integer> thresholdByName;
        private final int edgeValue;
        private final String javaDateSetter;
        private final String javaDateGetter;
        private final String calendarConstant;
        private final String gregorianParam;

        private Threshold(int edgeValue, String javaDateSetter, String javaDateGetter, String calendarConstant, String gregorianParam) {
            this.edgeValue = edgeValue;
            this.javaDateSetter = javaDateSetter;
            this.javaDateGetter = javaDateGetter;
            this.calendarConstant = calendarConstant;
            this.gregorianParam = gregorianParam;
        }

        public static Integer getThreshold(String name) {
            return thresholdByName.get(name);
        }

        static {
            thresholdByName = Maps.newHashMap();
            for (Threshold value : Threshold.values()) {
                thresholdByName.put(value.javaDateSetter, value.edgeValue);
                thresholdByName.put(value.javaDateGetter, value.edgeValue);
                thresholdByName.put(value.calendarConstant, value.edgeValue);
                thresholdByName.put(value.gregorianParam, value.edgeValue);
            }
        }
    }
}

