/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.RspecKey;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifierKeywordTree;
import org.sonar.plugins.java.api.tree.ModifierTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="ModifiersOrderCheck")
@RspecKey(value="S1124")
public class ModifiersOrderCheck
extends IssuableSubscriptionVisitor {
    private Set<Tree> alreadyReported = Sets.newHashSet();

    public void setContext(JavaFileScannerContext context) {
        this.alreadyReported.clear();
        super.setContext(context);
    }

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.MODIFIERS);
    }

    public void visitNode(Tree tree) {
        if (!this.alreadyReported.contains(tree)) {
            this.alreadyReported.add(tree);
            ModifierTree badlyOrderedModifier = ModifiersOrderCheck.getFirstBadlyOrdered((ModifiersTree)tree);
            if (badlyOrderedModifier != null) {
                this.reportIssue((Tree)badlyOrderedModifier, "Reorder the modifiers to comply with the Java Language Specification.");
            }
        }
    }

    private static ModifierTree getFirstBadlyOrdered(ModifiersTree modifiersTree) {
        ModifierTree modifier;
        ListIterator modifiersIterator = modifiersTree.listIterator();
        ModifiersOrderCheck.skipAnnotations(modifiersIterator);
        Modifier[] modifiers = Modifier.values();
        int modifierIndex = 0;
        while (modifiersIterator.hasNext() && !(modifier = (ModifierTree)modifiersIterator.next()).is(new Tree.Kind[]{Tree.Kind.ANNOTATION})) {
            ModifierKeywordTree mkt = (ModifierKeywordTree)modifier;
            while (modifierIndex < modifiers.length && !mkt.modifier().equals((Object)modifiers[modifierIndex])) {
                ++modifierIndex;
            }
            if (modifierIndex != modifiers.length) continue;
            return modifier;
        }
        return ModifiersOrderCheck.testOnlyAnnotationsAreLeft(modifiersIterator);
    }

    private static void skipAnnotations(ListIterator<ModifierTree> modifiersIterator) {
        while (modifiersIterator.hasNext() && modifiersIterator.next().is(new Tree.Kind[]{Tree.Kind.ANNOTATION})) {
        }
        if (modifiersIterator.hasNext()) {
            modifiersIterator.previous();
        }
    }

    private static ModifierTree testOnlyAnnotationsAreLeft(ListIterator<ModifierTree> modifiersIterator) {
        while (modifiersIterator.hasNext()) {
            ModifierTree modifier = modifiersIterator.next();
            if (modifier.is(new Tree.Kind[]{Tree.Kind.ANNOTATION})) continue;
            modifiersIterator.previous();
            if (!modifiersIterator.hasPrevious()) continue;
            return modifiersIterator.previous();
        }
        return null;
    }
}

