/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.NameCriteria;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2384")
public class MutableMembersUsageCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final List<String> MUTABLE_TYPES = ImmutableList.of((Object)"java.util.Collection", (Object)"java.util.Date", (Object)"java.util.Hashtable");
    private static final List<String> IMMUTABLE_TYPES = ImmutableList.of((Object)"java.util.Collections.UnmodifiableCollection", (Object)"java.util.Collections.UnmodifiableMap", (Object)"com.google.common.collect.ImmutableCollection");
    private static final MethodMatcher UNMODIFIABLE_COLLECTION_CALL = MethodMatcher.create().typeDefinition("java.util.Collections").name(NameCriteria.startsWith((String)"unmodifiable")).withAnyParameters();
    private JavaFileScannerContext context;
    private Deque<List<Symbol>> parametersStack = new LinkedList<List<Symbol>>();

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitMethod(MethodTree tree) {
        ArrayList<Symbol> parameters = new ArrayList<Symbol>();
        for (VariableTree variableTree : tree.parameters()) {
            parameters.add(variableTree.symbol());
        }
        this.parametersStack.push(parameters);
        super.visitMethod(tree);
        this.parametersStack.pop();
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        super.visitAssignmentExpression(tree);
        if (!MutableMembersUsageCheck.isMutableType(tree.expression())) {
            return;
        }
        ExpressionTree variable = tree.variable();
        Symbol leftSymbol = null;
        if (variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            IdentifierTree identifierTree = (IdentifierTree)variable;
            leftSymbol = identifierTree.symbol();
        } else if (variable.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree mit = (MemberSelectExpressionTree)variable;
            leftSymbol = mit.identifier().symbol();
        }
        if (leftSymbol != null && leftSymbol.isPrivate()) {
            this.checkStore(tree.expression());
        }
    }

    public void visitVariable(VariableTree tree) {
        super.visitVariable(tree);
        ExpressionTree initializer = tree.initializer();
        if (initializer == null || !MutableMembersUsageCheck.isMutableType(initializer)) {
            return;
        }
        this.checkStore(initializer);
    }

    private void checkStore(ExpressionTree expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            IdentifierTree identifierTree = (IdentifierTree)expression;
            if (!this.parametersStack.isEmpty() && this.parametersStack.peek().contains(identifierTree.symbol())) {
                this.context.reportIssue((JavaCheck)this, (Tree)identifierTree, "Store a copy of \"" + identifierTree.name() + "\".");
            }
        }
    }

    public void visitReturnStatement(ReturnStatementTree tree) {
        super.visitReturnStatement(tree);
        ExpressionTree expressionTree = tree.expression();
        if (expressionTree == null || !MutableMembersUsageCheck.isMutableType(expressionTree)) {
            return;
        }
        this.checkReturnedExpression(expressionTree);
    }

    private void checkReturnedExpression(ExpressionTree expression) {
        IdentifierTree identifierTree;
        MemberSelectExpressionTree mse;
        if (expression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && MutableMembersUsageCheck.isThis((mse = (MemberSelectExpressionTree)expression).expression())) {
            this.checkReturnedExpression((ExpressionTree)mse.identifier());
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && (identifierTree = (IdentifierTree)expression).symbol().isPrivate() && !MutableMembersUsageCheck.isImmutableFinalVariable((Symbol.VariableSymbol)identifierTree.symbol())) {
            this.context.reportIssue((JavaCheck)this, (Tree)identifierTree, "Return a copy of \"" + identifierTree.name() + "\".");
        }
    }

    private static boolean isThis(ExpressionTree expression) {
        return expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && ((IdentifierTree)expression).name().equals("this");
    }

    private static boolean isImmutableFinalVariable(Symbol.VariableSymbol symbol) {
        if (symbol.isFinal()) {
            VariableTree declaration = symbol.declaration();
            ExpressionTree initializer = declaration.initializer();
            if (initializer != null) {
                return !MutableMembersUsageCheck.isMutableType(initializer) || MutableMembersUsageCheck.isEmptyArray(initializer);
            }
            return !MutableMembersUsageCheck.assignementsOfMutableType(symbol.usages());
        }
        return false;
    }

    private static boolean isEmptyArray(ExpressionTree initializer) {
        return initializer.is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY}) && !((NewArrayTree)initializer).dimensions().isEmpty() && ((NewArrayTree)initializer).dimensions().stream().allMatch(adt -> MutableMembersUsageCheck.isZeroLiteralValue(adt.expression()));
    }

    private static boolean isZeroLiteralValue(@Nullable ExpressionTree expressionTree) {
        if (expressionTree == null) {
            return false;
        }
        Integer integer = LiteralUtils.intLiteralValue((ExpressionTree)expressionTree);
        return integer != null && integer == 0;
    }

    private static boolean assignementsOfMutableType(List<IdentifierTree> usages) {
        Iterator<IdentifierTree> iterator = usages.iterator();
        while (iterator.hasNext()) {
            AssignmentExpressionTree assignment;
            IdentifierTree usage;
            IdentifierTree current = usage = iterator.next();
            Tree parent = usage.parent();
            while (!parent.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT}) && (parent = (current = parent).parent()) != null) {
            }
            if (parent == null || !(assignment = (AssignmentExpressionTree)parent).variable().equals(current) || !MutableMembersUsageCheck.isMutableType(assignment.expression())) continue;
            return true;
        }
        return false;
    }

    private static boolean isMutableType(ExpressionTree expressionTree) {
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && UNMODIFIABLE_COLLECTION_CALL.matches((MethodInvocationTree)expressionTree)) {
            return false;
        }
        return MutableMembersUsageCheck.isMutableType(expressionTree.symbolType());
    }

    private static boolean isMutableType(Type type) {
        if (type.isArray()) {
            return true;
        }
        for (String mutableType : MUTABLE_TYPES) {
            if (!type.isSubtypeOf(mutableType) || !MutableMembersUsageCheck.isNotImmutable(type)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNotImmutable(Type type) {
        for (String immutableType : IMMUTABLE_TYPES) {
            if (!type.isSubtypeOf(immutableType)) continue;
            return false;
        }
        return true;
    }
}

