/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1659")
public class OneDeclarationPerLineCheck
extends IssuableSubscriptionVisitor {
    private boolean varSameDeclaration;
    private int lastVarLine;

    public void setContext(JavaFileScannerContext context) {
        this.lastVarLine = -1;
        this.varSameDeclaration = false;
        super.setContext(context);
    }

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.INTERFACE, (Object)Tree.Kind.CLASS, (Object)Tree.Kind.ENUM, (Object)Tree.Kind.ANNOTATION_TYPE, (Object)Tree.Kind.BLOCK, (Object)Tree.Kind.STATIC_INITIALIZER, (Object)Tree.Kind.CASE_GROUP);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.INTERFACE, Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.ANNOTATION_TYPE})) {
            this.checkVariables(((ClassTree)tree).members());
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.BLOCK, Tree.Kind.STATIC_INITIALIZER})) {
            this.checkVariables(((BlockTree)tree).body());
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.CASE_GROUP})) {
            this.checkVariables(((CaseGroupTree)tree).body());
        }
    }

    private void checkVariables(List<? extends Tree> trees) {
        for (Tree tree : trees) {
            if (!tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) continue;
            this.checkVariable((VariableTree)tree);
        }
    }

    private void checkVariable(VariableTree varTree) {
        int line = varTree.simpleName().identifierToken().line();
        if (this.varSameDeclaration || this.lastVarLine == line) {
            this.reportIssue((Tree)varTree.simpleName(), String.format("Declare \"%s\" on a separate line.", varTree.simpleName().name()));
        }
        this.varSameDeclaration = ",".equals(varTree.endToken().text());
        this.lastVarLine = line;
    }
}

