/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1161")
public class OverrideAnnotationCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic() || OverrideAnnotationCheck.isExcludedByVersion(this.context.getJavaVersion())) {
            return;
        }
        MethodTree methodTree = (MethodTree)tree;
        Symbol.MethodSymbol methodSymbol = methodTree.symbol();
        Symbol.MethodSymbol overriddenSymbol = methodSymbol.overriddenSymbol();
        if (overriddenSymbol == null || overriddenSymbol.isUnknown()) {
            return;
        }
        if (!(overriddenSymbol.isAbstract() || overriddenSymbol.owner().type().is("java.lang.Object") || methodSymbol.metadata().isAnnotatedWith("java.lang.Override"))) {
            this.reportIssue((Tree)methodTree.simpleName(), "Add the \"@Override\" annotation above this method signature");
        }
    }

    private static boolean isExcludedByVersion(JavaVersion javaVersion) {
        if (javaVersion.isNotSet()) {
            return false;
        }
        return javaVersion.asInt() <= 4;
    }
}

