/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S4248")
public class RegexPatternsNeedlesslyCheck
extends AbstractMethodDetection {
    private static final String STRING = "java.lang.String";
    private static final String PATTERN = "java.util.regex.Pattern";
    private static final Pattern SPLIT_EXCLUSION = Pattern.compile("[\\$\\.\\|\\(\\)\\[\\{\\^\\?\\*\\+\\\\]|\\\\\\w");

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodMatcher.create().typeDefinition(PATTERN).name("compile").addParameter(STRING), (Object)MethodMatcher.create().typeDefinition(STRING).name("matches").withAnyParameters(), (Object)MethodMatcher.create().typeDefinition(STRING).name("split").withAnyParameters(), (Object)MethodMatcher.create().typeDefinition(STRING).name("replaceAll").withAnyParameters(), (Object)MethodMatcher.create().typeDefinition(STRING).name("replaceFirst").withAnyParameters());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        String argValue;
        ExpressionTree firstArgument = ExpressionUtils.skipParentheses((ExpressionTree)((ExpressionTree)mit.arguments().get(0)));
        if (RegexPatternsNeedlesslyCheck.isSplitMethod(mit) && firstArgument.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) && (RegexPatternsNeedlesslyCheck.exceptionSplitMethod(argValue = LiteralUtils.trimQuotes((String)((LiteralTree)firstArgument).value())) && !SPLIT_EXCLUSION.matcher(argValue).matches() || RegexPatternsNeedlesslyCheck.metaCharactersInSplit(argValue))) {
            return;
        }
        if (!RegexPatternsNeedlesslyCheck.storedInStaticFinal(mit) && (firstArgument.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) || RegexPatternsNeedlesslyCheck.isConstant((Tree)firstArgument))) {
            this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), (Tree)mit.arguments(), "Refactor this code to use a \"static final\" Pattern.");
        }
    }

    private static boolean storedInStaticFinal(MethodInvocationTree mit) {
        Tree tree = mit.parent();
        while (!tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE, Tree.Kind.ASSIGNMENT, Tree.Kind.COMPILATION_UNIT})) {
            tree = tree.parent();
        }
        return RegexPatternsNeedlesslyCheck.isConstant(tree);
    }

    private static boolean isConstant(Tree tree) {
        Symbol symbol = null;
        switch (tree.kind()) {
            case IDENTIFIER: {
                symbol = ((IdentifierTree)tree).symbol();
                break;
            }
            case MEMBER_SELECT: {
                symbol = ((MemberSelectExpressionTree)tree).identifier().symbol();
                break;
            }
            case VARIABLE: {
                symbol = ((VariableTree)tree).symbol();
                break;
            }
            case ASSIGNMENT: {
                return RegexPatternsNeedlesslyCheck.isConstant((Tree)((AssignmentExpressionTree)tree).variable());
            }
        }
        return symbol != null && symbol.isFinal() && symbol.isStatic();
    }

    private static boolean metaCharactersInSplit(String argValue) {
        int strLength = argValue.length();
        return strLength == 3 && argValue.charAt(1) == '\\' && argValue.charAt(0) == '\\' && SPLIT_EXCLUSION.matcher(Character.toString(argValue.charAt(2))).matches() || strLength == 4 && argValue.charAt(0) == '\\' && argValue.charAt(3) == '\\';
    }

    private static boolean exceptionSplitMethod(String argValue) {
        int strLength = argValue.length();
        return strLength == 1 || strLength == 2 && argValue.charAt(0) == '\\';
    }

    private static boolean isSplitMethod(MethodInvocationTree mit) {
        return mit.symbol().name().equals("split");
    }
}

