/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S4738")
public class ReplaceGuavaWithJava8Check
extends AbstractMethodDetection
implements JavaVersionAwareVisitor {
    private static final String USE_INSTEAD = "Use \"%s\" instead.";
    private static final String GUAVA_BASE_ENCODING = "com.google.common.io.BaseEncoding";
    private static final String GUAVA_OPTIONAL = "com.google.common.base.Optional";
    private static final String GUAVA_JOINER = "com.google.common.base.Joiner";
    private static final Map<String, String> GUAVA_TO_JAVA_UTIL_TYPES = ImmutableMap.builder().put((Object)"com.google.common.base.Predicate", (Object)"java.util.function.Predicate").put((Object)"com.google.common.base.Function", (Object)"java.util.function.Function").put((Object)"com.google.common.base.Supplier", (Object)"java.util.function.Supplier").put((Object)"com.google.common.base.Optional", (Object)"java.util.Optional").build();
    private static final Map<String, String> GUAVA_OPTIONAL_TO_JAVA_UTIL_METHODS = ImmutableMap.builder().put((Object)"of", (Object)"of").put((Object)"absent", (Object)"empty").put((Object)"fromNullable", (Object)"ofNullable").build();

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava8Compatible();
    }

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Collections.unmodifiableList(Arrays.asList(MethodMatcher.create().typeDefinition(GUAVA_BASE_ENCODING).name("base64").withoutParameter(), MethodMatcher.create().typeDefinition(GUAVA_BASE_ENCODING).name("base64Url").withoutParameter(), MethodMatcher.create().typeDefinition(GUAVA_OPTIONAL).name("absent").withoutParameter(), MethodMatcher.create().typeDefinition(GUAVA_OPTIONAL).name("fromNullable").withAnyParameters(), MethodMatcher.create().typeDefinition(GUAVA_OPTIONAL).name("of").withAnyParameters(), MethodMatcher.create().typeDefinition(GUAVA_JOINER).name("on").withAnyParameters()));
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Stream.concat(Stream.of(Tree.Kind.VARIABLE), super.nodesToVisit().stream()).collect(Collectors.toList());
    }

    @Override
    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            this.checkTypeToReplace((VariableTree)tree);
        } else {
            super.visitNode(tree);
        }
    }

    private void checkTypeToReplace(VariableTree variableTree) {
        String fullyQualifiedTypeName = variableTree.type().symbolType().fullyQualifiedName();
        if (GUAVA_TO_JAVA_UTIL_TYPES.containsKey(fullyQualifiedTypeName)) {
            this.reportIssue((Tree)variableTree.type(), this.replacementMessage(GUAVA_TO_JAVA_UTIL_TYPES.get(fullyQualifiedTypeName)));
        }
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        switch (mit.symbol().owner().type().fullyQualifiedName()) {
            case "com.google.common.io.BaseEncoding": {
                this.reportIssue((Tree)mit, this.replacementMessage("java.util.Base64"));
                break;
            }
            case "com.google.common.base.Optional": {
                this.reportIssue((Tree)mit, this.replacementMessage("java.util.Optional." + GUAVA_OPTIONAL_TO_JAVA_UTIL_METHODS.get(mit.symbol().name())));
                break;
            }
            case "com.google.common.base.Joiner": {
                this.reportIssue((Tree)mit, this.replacementMessage("String.join\" or \"java.util.stream.Collectors.joining"));
                break;
            }
        }
    }

    private String replacementMessage(String replacement) {
        return String.format(USE_INSTEAD, replacement) + this.context.getJavaVersion().java8CompatibilityMessage();
    }
}

