/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.checks.helpers.ConstantUtils;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4719")
public class StandardCharsetsConstantsCheck
extends AbstractMethodDetection
implements JavaVersionAwareVisitor {
    private static final String JAVA_IO_INPUTSTREAM = "java.io.InputStream";
    private static final String JAVA_IO_OUTPUTSTREAM = "java.io.OutputStream";
    private static final String JAVA_IO_OUTPUTSTREAMWRITER = "java.io.OutputStreamWriter";
    private static final String JAVA_IO_INPUTSTREAMREADER = "java.io.InputStreamReader";
    private static final String JAVA_NIO_CHARSET = "java.nio.charset.Charset";
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final List<Charset> STANDARD_CHARSETS = Arrays.asList(StandardCharsets.ISO_8859_1, StandardCharsets.US_ASCII, StandardCharsets.UTF_16, StandardCharsets.UTF_16BE, StandardCharsets.UTF_16LE, StandardCharsets.UTF_8);
    private static final Map<String, String> ALIAS_TO_CONSTANT = StandardCharsetsConstantsCheck.createAliasToConstantNameMap();

    private static Map<String, String> createAliasToConstantNameMap() {
        ImmutableMap.Builder aliases = ImmutableMap.builder();
        for (Charset charset : STANDARD_CHARSETS) {
            aliases.put((Object)charset.name(), (Object)charset.name());
            for (String alias : charset.aliases()) {
                aliases.put((Object)alias, (Object)charset.name());
            }
        }
        return aliases.build();
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD_INVOCATION, (Object)Tree.Kind.NEW_CLASS, (Object)Tree.Kind.IDENTIFIER);
    }

    @Override
    public void visitNode(Tree tree) {
        super.visitNode(tree);
        if (this.hasSemantic() && tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            this.onMemberSelectExpressionFound((IdentifierTree)tree);
        }
    }

    private void onMemberSelectExpressionFound(IdentifierTree identifierTree) {
        Symbol symbol = identifierTree.symbol();
        if (symbol.isVariableSymbol() && symbol.owner().type().is("com.google.common.base.Charsets")) {
            String identifier = identifierTree.name();
            if (STANDARD_CHARSETS.stream().anyMatch(c -> c.name().equals(identifier.replace("_", "-")))) {
                this.reportIssue((Tree)identifierTree, "Replace \"com.google.common.base.Charsets." + identifier + "\" with \"StandardCharsets." + identifier + "\".");
            }
        }
    }

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Arrays.asList(MethodMatcher.create().typeDefinition(JAVA_NIO_CHARSET).name("forName").parameters(new String[]{JAVA_LANG_STRING}), MethodMatcher.create().typeDefinition(JAVA_LANG_STRING).name("getBytes").parameters(new String[]{JAVA_LANG_STRING}), MethodMatcher.create().typeDefinition(JAVA_LANG_STRING).name("getBytes").parameters(new String[]{JAVA_NIO_CHARSET}), StandardCharsetsConstantsCheck.constructor(JAVA_LANG_STRING).parameters(new String[]{"byte[]", JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.constructor(JAVA_LANG_STRING).parameters(new String[]{"byte[]", "int", "int", JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.constructor(JAVA_IO_INPUTSTREAMREADER).parameters(new String[]{JAVA_IO_INPUTSTREAM, JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.constructor(JAVA_IO_OUTPUTSTREAMWRITER).parameters(new String[]{JAVA_IO_OUTPUTSTREAM, JAVA_LANG_STRING}));
    }

    private static MethodMatcher constructor(String type) {
        return MethodMatcher.create().typeDefinition(type).name("<init>");
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (mit.symbol().name().equals("forName")) {
            this.checkCharsetForNameCall(mit);
        } else {
            this.checkArguments(mit.arguments());
        }
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        this.checkArguments(newClassTree.arguments());
    }

    private void checkCharsetForNameCall(MethodInvocationTree mit) {
        ExpressionTree argument = (ExpressionTree)mit.arguments().get(0);
        String constantName = StandardCharsetsConstantsCheck.getConstantName(argument);
        if (constantName != null) {
            this.reportIssue((Tree)mit, "Replace Charset.forName() call with StandardCharsets." + constantName);
        }
    }

    private void checkArguments(Arguments arguments) {
        ExpressionTree lastArgument = (ExpressionTree)arguments.get(arguments.size() - 1);
        String constantName = StandardCharsetsConstantsCheck.getConstantName(lastArgument);
        if (constantName != null) {
            this.reportIssue((Tree)lastArgument, "Replace charset name argument with StandardCharsets." + constantName);
        }
    }

    private static String getConstantName(ExpressionTree argument) {
        String constantValue = ConstantUtils.resolveAsStringConstant(argument);
        return ALIAS_TO_CONSTANT.get(constantValue);
    }

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava7Compatible();
    }
}

