/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2225")
public class ToStringReturningNullCheck
extends IssuableSubscriptionVisitor {
    private String interestingMethodName = null;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD, (Object)Tree.Kind.RETURN_STATEMENT);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            this.interestingMethodName = ToStringReturningNullCheck.interestingMethodName((MethodTree)tree);
        } else if (this.interestingMethodName != null) {
            ExpressionTree returnExpression = ExpressionUtils.skipParentheses((ExpressionTree)((ReturnStatementTree)tree).expression());
            if (returnExpression.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL})) {
                if (this.interestingMethodName.equals("toString")) {
                    this.reportIssue((Tree)returnExpression, "Return empty string instead.");
                } else {
                    this.reportIssue((Tree)returnExpression, "Return a non null object.");
                }
            }
        }
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            this.interestingMethodName = null;
        }
    }

    private static String interestingMethodName(MethodTree method) {
        String methodName = method.simpleName().name();
        if (method.parameters().isEmpty() && ("toString".equals(methodName) || "clone".equals(methodName))) {
            return methodName;
        }
        return null;
    }
}

