/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.RspecKey;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S00107")
@RspecKey(value="S107")
public class TooManyParametersCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final int DEFAULT_MAXIMUM = 7;
    @RuleProperty(key="max", description="Maximum authorized number of parameters", defaultValue="7")
    public int maximum = 7;
    @RuleProperty(key="constructorMax", description="Maximum authorized number of parameters for a constructor", defaultValue="7")
    public int constructorMax = 7;
    private JavaFileScannerContext context;
    private static final List<String> WHITE_LIST = ImmutableList.of((Object)"org.springframework.web.bind.annotation.RequestMapping", (Object)"org.springframework.web.bind.annotation.GetMapping", (Object)"org.springframework.web.bind.annotation.PostMapping", (Object)"org.springframework.web.bind.annotation.PutMapping", (Object)"org.springframework.web.bind.annotation.DeleteMapping", (Object)"org.springframework.web.bind.annotation.PatchMapping", (Object)"com.fasterxml.jackson.annotation.JsonCreator");

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitMethod(MethodTree tree) {
        String partialMessage;
        int max;
        super.visitMethod(tree);
        if (TooManyParametersCheck.isOverriding(tree) || this.hasSemantic() && TooManyParametersCheck.usesAuthorizedAnnotation(tree)) {
            return;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR})) {
            max = this.constructorMax;
            partialMessage = "Constructor";
        } else {
            max = this.maximum;
            partialMessage = "Method";
        }
        int size = tree.parameters().size();
        if (size > max) {
            this.context.reportIssue((JavaCheck)this, (Tree)tree.simpleName(), partialMessage + " has " + size + " parameters, which is greater than " + max + " authorized.");
        }
    }

    private static boolean isOverriding(MethodTree tree) {
        return Boolean.TRUE.equals(tree.isOverriding());
    }

    private boolean hasSemantic() {
        return this.context.getSemanticModel() != null;
    }

    private static boolean usesAuthorizedAnnotation(MethodTree method) {
        SymbolMetadata metadata = method.symbol().metadata();
        return WHITE_LIST.stream().anyMatch(arg_0 -> ((SymbolMetadata)metadata).isAnnotatedWith(arg_0));
    }
}

