/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;

@Rule(key="S3078")
public class VolatileVariablesOperationsCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.PREFIX_INCREMENT, (Object)Tree.Kind.POSTFIX_INCREMENT, (Object)Tree.Kind.PREFIX_DECREMENT, (Object)Tree.Kind.POSTFIX_DECREMENT, (Object)Tree.Kind.LOGICAL_COMPLEMENT, (Object)Tree.Kind.MULTIPLY_ASSIGNMENT, (Object)Tree.Kind.DIVIDE_ASSIGNMENT, (Object)Tree.Kind.REMAINDER_ASSIGNMENT, (Object)Tree.Kind.PLUS_ASSIGNMENT, (Object)Tree.Kind.MINUS_ASSIGNMENT, (Object)Tree.Kind.LEFT_SHIFT_ASSIGNMENT, (Object)Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, (Object[])new Tree.Kind[]{Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.XOR_ASSIGNMENT, Tree.Kind.OR_ASSIGNMENT});
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        ExpressionTree expression = tree instanceof UnaryExpressionTree ? ExpressionUtils.skipParentheses((ExpressionTree)((UnaryExpressionTree)tree).expression()) : ((AssignmentExpressionTree)tree).variable();
        IdentifierTree identifier = VolatileVariablesOperationsCheck.getVariableIdentifier(expression);
        if (identifier == null || !identifier.symbol().isVolatile()) {
            return;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.LOGICAL_COMPLEMENT})) {
            this.checkBooleanToggling(tree, identifier.symbol());
        } else {
            this.checkIncrementDecrement(tree, identifier);
        }
    }

    @Nullable
    private static IdentifierTree getVariableIdentifier(ExpressionTree expressionTree) {
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return (IdentifierTree)expressionTree;
        }
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return ((MemberSelectExpressionTree)expressionTree).identifier();
        }
        return null;
    }

    private void checkBooleanToggling(Tree tree, Symbol identifierSymbol) {
        IdentifierTree variableIdentifier;
        Tree parent = tree.parent();
        if (parent.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION})) {
            this.checkBooleanToggling(parent, identifierSymbol);
        } else if (parent.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT}) && (variableIdentifier = VolatileVariablesOperationsCheck.getVariableIdentifier(((AssignmentExpressionTree)parent).variable())) != null && identifierSymbol.equals(variableIdentifier.symbol())) {
            this.reportIssueIfNotInExcludedContext(tree, "AtomicBoolean");
        }
    }

    private void checkIncrementDecrement(Tree tree, IdentifierTree identifier) {
        Type symbolType = identifier.symbol().type();
        if (symbolType.is("int") || symbolType.is("java.lang.Integer")) {
            this.reportIssueIfNotInExcludedContext(tree, "AtomicInteger");
        } else if (symbolType.is("long") || symbolType.is("java.lang.Long")) {
            this.reportIssueIfNotInExcludedContext(tree, "AtomicLong");
        }
    }

    private void reportIssueIfNotInExcludedContext(Tree tree, String recommendedType) {
        Tree current = tree.parent();
        boolean foundClass = false;
        while (!foundClass) {
            switch (current.kind()) {
                case LAMBDA_EXPRESSION: 
                case SYNCHRONIZED_STATEMENT: 
                case COMPILATION_UNIT: {
                    return;
                }
                case METHOD: {
                    if (!ModifiersUtils.hasModifier((ModifiersTree)((MethodTree)current).modifiers(), (Modifier)Modifier.SYNCHRONIZED)) break;
                    return;
                }
                case ENUM: 
                case CLASS: {
                    if (((ClassTree)current).simpleName() == null) {
                        return;
                    }
                    foundClass = true;
                }
            }
            current = current.parent();
        }
        this.reportIssue(tree, String.format("Use an \"%s\" for this field; its operations are atomic.", recommendedType));
    }
}

