/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.naming;

import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.RspecKey;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S00118")
@RspecKey(value="S118")
public class BadAbstractClassNameCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String DEFAULT_FORMAT = "^Abstract[A-Z][a-zA-Z0-9]*$";
    @RuleProperty(key="format", description="Regular expression used to check the abstract class names against.", defaultValue="^Abstract[A-Z][a-zA-Z0-9]*$")
    public String format = "^Abstract[A-Z][a-zA-Z0-9]*$";
    private Pattern pattern = null;
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format, 32);
        }
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        IdentifierTree simpleName = tree.simpleName();
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS}) && simpleName != null) {
            if (this.pattern.matcher(simpleName.name()).matches()) {
                if (!BadAbstractClassNameCheck.isAbstract(tree)) {
                    this.context.reportIssue((JavaCheck)this, (Tree)simpleName, "Make this class abstract or rename it, since it matches the regular expression '" + this.format + "'.");
                }
            } else if (BadAbstractClassNameCheck.isAbstract(tree)) {
                this.context.reportIssue((JavaCheck)this, (Tree)simpleName, "Rename this abstract class name to match the regular expression '" + this.format + "'.");
            }
        }
        super.visitClass(tree);
    }

    private static boolean isAbstract(ClassTree tree) {
        return ModifiersUtils.hasModifier((ModifiersTree)tree.modifiers(), (Modifier)Modifier.ABSTRACT);
    }
}

