/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.naming;

import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.RspecKey;
import org.sonar.java.model.PackageUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.PackageDeclarationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S00120")
@RspecKey(value="S120")
public class BadPackageNameCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String DEFAULT_FORMAT = "^[a-z_]+(\\.[a-z_][a-z0-9_]*)*$";
    @RuleProperty(key="format", description="Regular expression used to check the package names against.", defaultValue="^[a-z_]+(\\.[a-z_][a-z0-9_]*)*$")
    public String format = "^[a-z_]+(\\.[a-z_][a-z0-9_]*)*$";
    private Pattern pattern = null;
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format, 32);
        }
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitCompilationUnit(CompilationUnitTree tree) {
        String name;
        if (tree.packageDeclaration() != null && !this.pattern.matcher(name = PackageUtils.packageName((PackageDeclarationTree)tree.packageDeclaration(), (String)".")).matches()) {
            this.context.reportIssue((JavaCheck)this, (Tree)tree.packageDeclaration().packageName(), "Rename this package name to match the regular expression '" + this.format + "'.");
        }
    }
}

