/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.naming;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3577")
public class BadTestClassNameCheck
extends IssuableSubscriptionVisitor {
    private static final String DEFAULT_FORMAT = "^((Test|IT)[a-zA-Z0-9]+|[A-Z][a-zA-Z0-9]*(Test|IT|TestCase|ITCase))$";
    @RuleProperty(key="format", description="Regular expression against which test class names are checked.", defaultValue="^((Test|IT)[a-zA-Z0-9]+|[A-Z][a-zA-Z0-9]*(Test|IT|TestCase|ITCase))$")
    public String format = "^((Test|IT)[a-zA-Z0-9]+|[A-Z][a-zA-Z0-9]*(Test|IT|TestCase|ITCase))$";
    private Pattern pattern = null;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void setContext(JavaFileScannerContext context) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format, 32);
        }
        super.setContext(context);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        ClassTree classTree = (ClassTree)tree;
        IdentifierTree simpleName = classTree.simpleName();
        if (this.hasInvalidName(simpleName) && BadTestClassNameCheck.hasTestMethod(classTree.members())) {
            this.reportIssue((Tree)simpleName, "Rename class \"" + simpleName + "\" to match the regular expression: '" + this.format + "'");
        }
    }

    private boolean hasInvalidName(@Nullable IdentifierTree className) {
        return className != null && !this.pattern.matcher(className.name()).matches();
    }

    private static boolean hasTestMethod(List<Tree> members) {
        return members.stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.METHOD})).map(tree -> ((MethodTree)tree).symbol().metadata()).anyMatch(metadata -> metadata.isAnnotatedWith("org.junit.Test") || metadata.isAnnotatedWith("org.testng.annotations.Test"));
    }
}

