/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.naming;

import com.google.common.collect.Lists;
import java.util.Collection;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1700")
public class FieldNameMatchingTypeNameCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;
    private String currentClassName;
    private Collection<Tree> fields;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.currentClassName = "";
        this.fields = Lists.newArrayList();
        if (context.getSemanticModel() != null) {
            this.scan((Tree)context.getTree());
        }
    }

    public void visitClass(ClassTree tree) {
        IdentifierTree simpleName = tree.simpleName();
        if (simpleName != null) {
            Symbol.TypeSymbol classSymbol = tree.symbol();
            Collection members = classSymbol.memberSymbols();
            for (Symbol sym : members) {
                if (!sym.isVariableSymbol() || FieldNameMatchingTypeNameCheck.staticFieldSameType((Symbol)classSymbol, sym)) continue;
                this.fields.add((Tree)((Symbol.VariableSymbol)sym).declaration());
            }
            this.currentClassName = simpleName.name();
        }
        super.visitClass(tree);
        this.currentClassName = "";
        this.fields.clear();
    }

    private static boolean staticFieldSameType(Symbol classSymbol, Symbol sym) {
        return sym.type().equals(classSymbol.type()) && sym.isStatic();
    }

    public void visitVariable(VariableTree tree) {
        String name = tree.simpleName().name();
        if (this.fields.contains(tree) && this.currentClassName.equalsIgnoreCase(name)) {
            this.context.reportIssue((JavaCheck)this, (Tree)tree.simpleName(), "Rename field \"" + name + "\"");
        }
        super.visitVariable(tree);
    }
}

