/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ConstantUtils;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S3330")
public class CookieHttpOnlyCheck
extends IssuableSubscriptionVisitor {
    private final List<Symbol.VariableSymbol> compliantConstructorInitializations = Lists.newArrayList();
    private final List<Symbol.VariableSymbol> ignoredVariables = Lists.newArrayList();
    private final List<Symbol.VariableSymbol> variablesToReport = Lists.newArrayList();
    private final List<MethodInvocationTree> settersToReport = Lists.newArrayList();
    private final List<NewClassTree> newClassToReport = Lists.newArrayList();
    private static final List<String> IGNORED_COOKIE_NAMES = ImmutableList.of((Object)"csrf", (Object)"xsrf");
    private static final String CONSTRUCTOR = "<init>";
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String JAVA_UTIL_DATE = "java.util.Date";
    private static final String INT = "int";
    private static final String BOOLEAN = "boolean";
    private static final String MESSAGE = "Add the \"HttpOnly\" cookie attribute.";
    private static final int COOKIE_NAME_ARGUMENT = 0;
    private static final List<String> SETTER_NAMES = Arrays.asList("setHttpOnly", "withHttpOnly");
    private static final List<String> CLASSES = Arrays.asList("javax.servlet.http.Cookie", "java.net.HttpCookie", "javax.ws.rs.core.Cookie", "org.apache.shiro.web.servlet.SimpleCookie", "play.mvc.Http$Cookie", "play.mvc.Http$CookieBuilder");
    private static final MethodMatcher PLAY_COOKIE_BUILDER = MethodMatcher.create().typeDefinition("play.mvc.Http$Cookie").name("builder").withAnyParameters();
    private static final List<MethodMatcher> CONSTRUCTORS_WITH_HTTP_ONLY_PARAM = Arrays.asList(MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"javax.ws.rs.core.NewCookie")).name("<init>").parameters(new String[]{"javax.ws.rs.core.Cookie", "java.lang.String", "int", "java.util.Date", "boolean", "boolean"}), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"javax.ws.rs.core.NewCookie")).name("<init>").parameters(new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "int", "java.lang.String", "int", "java.util.Date", "boolean", "boolean"}), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"javax.ws.rs.core.NewCookie")).name("<init>").parameters(new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "int", "boolean", "boolean"}), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"play.mvc.Http$Cookie")).name("<init>").parameters(new String[]{"java.lang.String", "java.lang.String", "java.lang.Integer", "java.lang.String", "java.lang.String", "boolean", "boolean"}));
    private static final List<MethodMatcher> CONSTRUCTORS_WITH_GOOD_DEFAULT = Arrays.asList(MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"org.apache.shiro.web.servlet.SimpleCookie")).name("<init>").withoutParameter(), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"org.apache.shiro.web.servlet.SimpleCookie")).name("<init>").parameters(new String[]{"java.lang.String"}));

    public void setContext(JavaFileScannerContext context) {
        this.compliantConstructorInitializations.clear();
        this.ignoredVariables.clear();
        this.variablesToReport.clear();
        this.settersToReport.clear();
        this.newClassToReport.clear();
        super.setContext(context);
    }

    public void leaveFile(JavaFileScannerContext context) {
        for (Symbol.VariableSymbol var : this.variablesToReport) {
            VariableTree declaration = var.declaration();
            if (declaration == null) continue;
            this.reportIssue((Tree)declaration.simpleName(), MESSAGE);
        }
        for (MethodInvocationTree mit : this.settersToReport) {
            this.reportIssue((Tree)mit.arguments(), MESSAGE);
        }
        for (NewClassTree newClassTree : this.newClassToReport) {
            this.reportIssue((Tree)newClassTree, MESSAGE);
        }
    }

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.VARIABLE, (Object)Tree.Kind.ASSIGNMENT, (Object)Tree.Kind.METHOD_INVOCATION, (Object)Tree.Kind.RETURN_STATEMENT);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
                this.checkVariableDeclaration((VariableTree)tree);
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
                this.checkAssignment((AssignmentExpressionTree)tree);
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                this.checkSetterInvocation((MethodInvocationTree)tree);
            } else {
                this.categorizeBasedOnConstructor((ReturnStatementTree)tree);
            }
        }
    }

    private void checkAssignment(AssignmentExpressionTree assignment) {
        this.checkCookieBuilder(assignment);
        if (CookieHttpOnlyCheck.shouldVerify(assignment)) {
            this.categorizeBasedOnConstructor((NewClassTree)assignment.expression(), (Symbol.VariableSymbol)((IdentifierTree)assignment.variable()).symbol());
        }
    }

    private void checkVariableDeclaration(VariableTree declaration) {
        this.checkCookieBuilder(declaration);
        if (CookieHttpOnlyCheck.shouldVerify(declaration)) {
            this.categorizeBasedOnConstructor((NewClassTree)declaration.initializer(), (Symbol.VariableSymbol)declaration.symbol());
        }
    }

    private void checkCookieBuilder(AssignmentExpressionTree assignment) {
        if (assignment.expression().is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && (assignment.variable().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) || assignment.variable().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}))) {
            MethodInvocationTree mit = (MethodInvocationTree)assignment.expression();
            Symbol.VariableSymbol variableSymbol = CookieHttpOnlyCheck.getVariableSymbol(assignment);
            if (variableSymbol != null) {
                this.addToIgnoredVariables(variableSymbol, mit);
            }
        }
    }

    @CheckForNull
    private static Symbol.VariableSymbol getVariableSymbol(AssignmentExpressionTree assignment) {
        Symbol.VariableSymbol variableSymbol = null;
        if (assignment.variable().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            Symbol reference = ((IdentifierTree)assignment.variable()).symbol();
            if (reference.isVariableSymbol()) {
                variableSymbol = (Symbol.VariableSymbol)reference;
            }
        } else {
            MemberSelectExpressionTree mse = (MemberSelectExpressionTree)assignment.variable();
            if (mse.identifier().symbol().isVariableSymbol()) {
                variableSymbol = (Symbol.VariableSymbol)mse.identifier().symbol();
            }
        }
        return variableSymbol;
    }

    private void addToIgnoredVariables(Symbol.VariableSymbol variableSymbol, MethodInvocationTree mit) {
        if (PLAY_COOKIE_BUILDER.matches(mit) && CookieHttpOnlyCheck.isIgnoredCookieName(mit.arguments())) {
            this.ignoredVariables.add(variableSymbol);
        }
    }

    private void checkCookieBuilder(VariableTree declaration) {
        if (declaration.initializer() != null && declaration.initializer().is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree mit = (MethodInvocationTree)declaration.initializer();
            this.addToIgnoredVariables((Symbol.VariableSymbol)declaration.symbol(), mit);
        }
    }

    private void categorizeBasedOnConstructor(ReturnStatementTree returnStatement) {
        NewClassTree newClass;
        ExpressionTree returnedExpression = returnStatement.expression();
        if (returnedExpression != null && returnedExpression.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS}) && !CookieHttpOnlyCheck.isIgnoredCookieName((newClass = (NewClassTree)returnedExpression).arguments()) && !CookieHttpOnlyCheck.isCompliantConstructorCall(newClass)) {
            if (CLASSES.stream().anyMatch(arg_0 -> ((Type)newClass.symbolType()).isSubtypeOf(arg_0))) {
                this.newClassToReport.add(newClass);
            }
        }
    }

    private void categorizeBasedOnConstructor(NewClassTree newClassTree, Symbol.VariableSymbol variableSymbol) {
        if (CookieHttpOnlyCheck.isIgnoredCookieName(newClassTree.arguments())) {
            this.ignoredVariables.add(variableSymbol);
        } else if (CookieHttpOnlyCheck.isCompliantConstructorCall(newClassTree)) {
            this.compliantConstructorInitializations.add(variableSymbol);
        } else {
            this.variablesToReport.add(variableSymbol);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static boolean shouldVerify(VariableTree variableDeclaration) {
        block2: {
            initializer = variableDeclaration.initializer();
            if (initializer == null || !initializer.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) break block2;
            if (CookieHttpOnlyCheck.CLASSES.stream().anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isSubtypeOf(java.lang.String ), (Ljava/lang/String;)Z)((Type)variableDeclaration.type().symbolType()))) ** GOTO lbl-1000
            if (CookieHttpOnlyCheck.CLASSES.stream().anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isSubtypeOf(java.lang.String ), (Ljava/lang/String;)Z)((Type)initializer.symbolType()))) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            isSupportedClass = v0;
            return variableDeclaration.symbol().owner().isMethodSymbol() != false && isSupportedClass != false;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean shouldVerify(AssignmentExpressionTree assignment) {
        block2: {
            if (!assignment.expression().is(new Tree.Kind[]{Tree.Kind.NEW_CLASS}) || !assignment.variable().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) break block2;
            identifier = (IdentifierTree)assignment.variable();
            isMethodVariable = identifier.symbol().isVariableSymbol() != false && identifier.symbol().owner().isMethodSymbol() != false;
            if (CookieHttpOnlyCheck.CLASSES.stream().anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isSubtypeOf(java.lang.String ), (Ljava/lang/String;)Z)((Type)identifier.symbolType()))) ** GOTO lbl-1000
            if (CookieHttpOnlyCheck.CLASSES.stream().anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isSubtypeOf(java.lang.String ), (Ljava/lang/String;)Z)((Type)assignment.expression().symbolType()))) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            isSupportedClass = v0;
            return isMethodVariable != false && isSupportedClass != false;
        }
        return false;
    }

    private static boolean isCompliantConstructorCall(NewClassTree newClassTree) {
        if (CONSTRUCTORS_WITH_HTTP_ONLY_PARAM.stream().anyMatch(matcher -> matcher.matches(newClassTree))) {
            Arguments arguments = newClassTree.arguments();
            ExpressionTree lastArgument = (ExpressionTree)arguments.get(arguments.size() - 1);
            return LiteralUtils.isTrue((Tree)lastArgument);
        }
        return CONSTRUCTORS_WITH_GOOD_DEFAULT.stream().anyMatch(matcher -> matcher.matches(newClassTree));
    }

    private static boolean isIgnoredCookieName(Arguments arguments) {
        if (arguments.isEmpty()) {
            return false;
        }
        ExpressionTree nameArgument = (ExpressionTree)arguments.get(0);
        String name = ConstantUtils.resolveAsStringConstant(nameArgument);
        return name != null && IGNORED_COOKIE_NAMES.stream().anyMatch(cookieName -> name.toLowerCase(Locale.ENGLISH).contains((CharSequence)cookieName));
    }

    private void checkSetterInvocation(MethodInvocationTree mit) {
        if (CookieHttpOnlyCheck.isExpectedSetter(mit)) {
            if (mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                ExpressionTree expression = ((MemberSelectExpressionTree)mit.methodSelect()).expression();
                boolean isCalledOnIdentifier = expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER});
                boolean isCalledOnMemberSelect = expression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT});
                if (isCalledOnIdentifier || isCalledOnMemberSelect) {
                    this.updateIssuesToReport(mit);
                } else if (!CookieHttpOnlyCheck.setterArgumentHasCompliantValue(mit.arguments())) {
                    this.settersToReport.add(mit);
                }
            } else if (!CookieHttpOnlyCheck.setterArgumentHasCompliantValue(mit.arguments())) {
                this.settersToReport.add(mit);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isExpectedSetter(MethodInvocationTree mit) {
        if (mit.arguments().size() != 1) return false;
        if (!mit.symbol().isMethodSymbol()) return false;
        if (!CLASSES.stream().anyMatch(arg_0 -> ((Type)mit.symbol().owner().type()).isSubtypeOf(arg_0))) return false;
        if (!SETTER_NAMES.contains(CookieHttpOnlyCheck.getIdentifier(mit).name())) return false;
        if (!CookieHttpOnlyCheck.isIgnoredBuilder(mit)) return false;
        return true;
    }

    private static boolean isIgnoredBuilder(MethodInvocationTree mit) {
        if (!mit.symbol().owner().type().isSubtypeOf("play.mvc.Http$CookieBuilder")) {
            return true;
        }
        return CookieHttpOnlyCheck.getMethodChain(mit).filter(method -> "builder".contains(CookieHttpOnlyCheck.getIdentifier(method).name())).noneMatch(method -> CookieHttpOnlyCheck.isIgnoredCookieName(method.arguments()));
    }

    private static Stream<MethodInvocationTree> getMethodChain(MethodInvocationTree mit) {
        if (mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            ExpressionTree expressionTree = ((MemberSelectExpressionTree)mit.methodSelect()).expression();
            if (expressionTree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                return Stream.concat(Stream.of(mit), CookieHttpOnlyCheck.getMethodChain((MethodInvocationTree)expressionTree));
            }
        }
        return Stream.of(mit);
    }

    private void updateIssuesToReport(MethodInvocationTree mit) {
        MemberSelectExpressionTree mse = (MemberSelectExpressionTree)mit.methodSelect();
        Symbol.VariableSymbol reference = mse.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) ? (Symbol.VariableSymbol)((IdentifierTree)mse.expression()).symbol() : (Symbol.VariableSymbol)((MemberSelectExpressionTree)mse.expression()).identifier().symbol();
        if (this.ignoredVariables.contains(reference)) {
            return;
        }
        if (CookieHttpOnlyCheck.setterArgumentHasCompliantValue(mit.arguments())) {
            this.variablesToReport.remove(reference);
        } else if (this.compliantConstructorInitializations.contains(reference)) {
            this.variablesToReport.add(reference);
        } else if (!this.variablesToReport.contains(reference)) {
            this.settersToReport.add(mit);
        }
    }

    private static boolean setterArgumentHasCompliantValue(Arguments arguments) {
        ExpressionTree expressionTree = (ExpressionTree)arguments.get(0);
        Boolean booleanValue = ConstantUtils.resolveAsBooleanConstant(expressionTree);
        return booleanValue == null || booleanValue != false;
    }

    private static IdentifierTree getIdentifier(MethodInvocationTree mit) {
        IdentifierTree id = mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) ? (IdentifierTree)mit.methodSelect() : ((MemberSelectExpressionTree)mit.methodSelect()).identifier();
        return id;
    }

    private static final class ClassName {
        private static final String SERVLET_COOKIE = "javax.servlet.http.Cookie";
        private static final String NET_HTTP_COOKIE = "java.net.HttpCookie";
        private static final String JAX_RS_COOKIE = "javax.ws.rs.core.Cookie";
        private static final String JAX_RS_NEW_COOKIE = "javax.ws.rs.core.NewCookie";
        private static final String SHIRO_COOKIE = "org.apache.shiro.web.servlet.SimpleCookie";
        private static final String PLAY_COOKIE = "play.mvc.Http$Cookie";
        private static final String PLAY_COOKIE_BUILDER = "play.mvc.Http$CookieBuilder";

        private ClassName() {
        }
    }
}

