/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2255")
public class CookieShouldNotContainSensitiveDataCheck
extends AbstractMethodDetection {
    private static final String MESSAGE = "Make sure that this cookie is used safely.";
    private static final List<String> COOKIE_ARGUMENT_TYPES = Arrays.asList("javax.servlet.http.Cookie", "javax.ws.rs.core.Cookie", "org.apache.shiro.web.servlet.Cookie");
    private static final String CONSTRUCTOR = "<init>";
    private static final String SET_VALUE_METHOD = "setValue";
    private static final String GET_VALUE_METHOD = "getValue";
    private static final String WITH_VALUE_METHOD = "withValue";
    private static final String BUILDER_METHOD = "builder";
    private static final String JAVA_LANG_STRING = "java.lang.String";

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Arrays.asList(MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"javax.servlet.http.Cookie")).name(GET_VALUE_METHOD).withoutParameter(), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"java.net.HttpCookie")).name(GET_VALUE_METHOD).withoutParameter(), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"org.apache.shiro.web.servlet.SimpleCookie")).name(GET_VALUE_METHOD).withoutParameter(), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"javax.ws.rs.core.Cookie")).name(GET_VALUE_METHOD).withoutParameter(), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"org.springframework.security.web.savedrequest.SavedCookie")).name(GET_VALUE_METHOD).withoutParameter(), MethodMatcher.create().typeDefinition("play.mvc.Http$Cookie").name("value").withoutParameter(), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"javax.servlet.http.Cookie")).name(SET_VALUE_METHOD).parameters(new String[]{JAVA_LANG_STRING}), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"java.net.HttpCookie")).name(SET_VALUE_METHOD).parameters(new String[]{JAVA_LANG_STRING}), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"org.apache.shiro.web.servlet.SimpleCookie")).name(SET_VALUE_METHOD).parameters(new String[]{JAVA_LANG_STRING}), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"javax.servlet.http.Cookie")).name(CONSTRUCTOR).withAnyParameters(), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"java.net.HttpCookie")).name(CONSTRUCTOR).withAnyParameters(), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"org.apache.shiro.web.servlet.SimpleCookie")).name(CONSTRUCTOR).withAnyParameters(), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"org.springframework.security.web.savedrequest.SavedCookie")).name(CONSTRUCTOR).withAnyParameters(), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"javax.ws.rs.core.Cookie")).name(CONSTRUCTOR).withAnyParameters(), MethodMatcher.create().typeDefinition("play.mvc.Http$Cookie").name(BUILDER_METHOD).parameters(new String[]{JAVA_LANG_STRING, JAVA_LANG_STRING}), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"play.mvc.Http$CookieBuilder")).name(WITH_VALUE_METHOD).parameters(new String[]{JAVA_LANG_STRING}));
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD_INVOCATION, (Object)Tree.Kind.NEW_CLASS, (Object)Tree.Kind.METHOD_REFERENCE, (Object)Tree.Kind.METHOD);
    }

    @Override
    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            ((MethodTree)tree).parameters().stream().filter(v -> v.symbol().metadata().isAnnotatedWith("org.springframework.web.bind.annotation.CookieValue")).forEach(v -> this.reportIssue((Tree)v.modifiers(), MESSAGE));
        } else {
            super.visitNode(tree);
        }
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree methodTree) {
        String methodName = methodTree.symbol().name();
        if (methodName.equals(BUILDER_METHOD)) {
            if (CookieShouldNotContainSensitiveDataCheck.secondArgumentIsValue(methodTree.arguments())) {
                this.reportIssue((Tree)methodTree.arguments().get(1), MESSAGE);
            }
        } else if (methodName.equals(GET_VALUE_METHOD) || methodName.equals("value")) {
            this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)methodTree), MESSAGE);
        } else if (CookieShouldNotContainSensitiveDataCheck.isNotNullOrWhitespace((Tree)methodTree.arguments().get(0))) {
            this.reportIssue((Tree)methodTree.arguments().get(0), MESSAGE);
        }
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        if (CookieShouldNotContainSensitiveDataCheck.firstArgumentIsCookie(newClassTree.arguments())) {
            this.reportIssue((Tree)newClassTree.arguments().get(0), MESSAGE);
        } else if (CookieShouldNotContainSensitiveDataCheck.secondArgumentIsValue(newClassTree.arguments())) {
            this.reportIssue((Tree)newClassTree.arguments().get(1), MESSAGE);
        }
    }

    private static boolean firstArgumentIsCookie(Arguments arguments) {
        if (arguments.isEmpty()) {
            return false;
        }
        ExpressionTree firstArgument = (ExpressionTree)arguments.get(0);
        return COOKIE_ARGUMENT_TYPES.stream().anyMatch(type -> firstArgument.symbolType().isSubtypeOf(type));
    }

    private static boolean secondArgumentIsValue(Arguments arguments) {
        if (arguments.size() < 2) {
            return false;
        }
        ExpressionTree secondArgument = (ExpressionTree)arguments.get(1);
        return secondArgument.symbolType().isSubtypeOf(JAVA_LANG_STRING) && CookieShouldNotContainSensitiveDataCheck.isNotNullOrWhitespace((Tree)secondArgument);
    }

    private static boolean isNotNullOrWhitespace(Tree tree) {
        return !tree.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL}) && (!tree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) || !StringUtils.isBlank((String)LiteralUtils.trimQuotes((String)((LiteralTree)tree).value())));
    }

    private static class ClassName {
        private static final String SERVLET_COOKIE = "javax.servlet.http.Cookie";
        private static final String NET_HTTP_COOKIE = "java.net.HttpCookie";
        private static final String JAX_RS_COOKIE = "javax.ws.rs.core.Cookie";
        private static final String SHIRO_COOKIE = "org.apache.shiro.web.servlet.SimpleCookie";
        private static final String SPRING_COOKIE = "org.springframework.security.web.savedrequest.SavedCookie";
        private static final String PLAY_COOKIE = "play.mvc.Http$Cookie";
        private static final String PLAY_COOKIE_BUILDER = "play.mvc.Http$CookieBuilder";

        private ClassName() {
        }
    }
}

