/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ConstantUtils;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4790")
public class DataHashingCheck
extends AbstractMethodDetection {
    private static final String DIGEST_UTILS = "org.apache.commons.codec.digest.DigestUtils";
    private static final String MESSAGE = "Make sure that hashing data is safe here.";
    private static final String SECRET_KEY_FACTORY = "javax.crypto.SecretKeyFactory";

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        ArrayList<MethodMatcher> matchers = new ArrayList<MethodMatcher>();
        matchers.add(MethodMatcher.create().typeDefinition("java.security.MessageDigest").name("getInstance").withAnyParameters());
        matchers.add(MethodMatcher.create().typeDefinition(DIGEST_UTILS).name("<init>").withAnyParameters());
        matchers.addAll(Stream.of("Md2", "Md5", "Sha", "Sha1", "Sha256", "Sha384", "Sha512").flatMap(alg -> Stream.of("get" + alg + "Digest", alg.toLowerCase(Locale.ENGLISH), alg.toLowerCase(Locale.ENGLISH) + "Hex")).map(name -> MethodMatcher.create().typeDefinition(DIGEST_UTILS).name(name).withAnyParameters()).collect(Collectors.toList()));
        matchers.addAll(Stream.of("md5", "sha1", "sha256", "sha384", "sha512").map(alg -> MethodMatcher.create().typeDefinition("com.google.common.hash.Hashing").name(alg).withoutParameter()).collect(Collectors.toList()));
        matchers.add(MethodMatcher.create().typeDefinition(SECRET_KEY_FACTORY).name("getInstance").withAnyParameters());
        return matchers;
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        String algorithm;
        if (mit.symbol().owner().type().is(SECRET_KEY_FACTORY) && ((algorithm = ConstantUtils.resolveAsStringConstant((ExpressionTree)mit.arguments().get(0))) == null || !algorithm.startsWith("PBKDF2"))) {
            return;
        }
        this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), MESSAGE);
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        this.reportIssue((Tree)newClassTree.identifier(), MESSAGE);
    }
}

