/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ConstantUtils;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1523")
public class DynamicCodeCheck
extends AbstractMethodDetection {
    private static final String JAVA_LANG_CLASS = "java.lang.Class";

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodMatcher.create().typeDefinition(JAVA_LANG_CLASS).name("forName").withAnyParameters(), (Object)MethodMatcher.create().typeDefinition(JAVA_LANG_CLASS).name("getMethod").withAnyParameters(), (Object)MethodMatcher.create().typeDefinition(JAVA_LANG_CLASS).name("getMethods").withoutParameter(), (Object)MethodMatcher.create().typeDefinition(JAVA_LANG_CLASS).name("getField").withAnyParameters(), (Object)MethodMatcher.create().typeDefinition(JAVA_LANG_CLASS).name("getFields").withoutParameter(), (Object)MethodMatcher.create().typeDefinition(JAVA_LANG_CLASS).name("getDeclaredField").withAnyParameters(), (Object)MethodMatcher.create().typeDefinition(JAVA_LANG_CLASS).name("getDeclaredFields").withoutParameter(), (Object)MethodMatcher.create().typeDefinition(JAVA_LANG_CLASS).name("getDeclaredClasses").withoutParameter(), (Object)MethodMatcher.create().typeDefinition("java.lang.ClassLoader").name("loadClass").withAnyParameters());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        Arguments arguments = mit.arguments();
        if (arguments.isEmpty() || ConstantUtils.resolveAsStringConstant((ExpressionTree)arguments.get(0)) == null) {
            this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), "Make sure that this dynamic injection or execution of code is safe.");
        }
    }
}

