/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ConstantUtils;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2115")
public class EmptyDatabasePasswordCheck
extends AbstractMethodDetection {
    private static final String MESSAGE = "Add password protection to this database.";
    private static final int PASSWORD_ARGUMENT = 2;
    private static final int URL_ARGUMENT = 0;
    private static final Pattern EMPTY_PASSWORD_PATTERN = Pattern.compile(".*password\\s*=\\s*([&;].*|$)");
    private static final Pattern MYSQL_URL_PATTERN = Pattern.compile("jdbc:mysql://.*:(?<password>.*)@.*");
    private static final Pattern ORACLE_URL_PATTERN = Pattern.compile("jdbc:oracle:.*:.*/(?<password>.*)@.*");
    private static final List<MethodMatcher> METHOD_MATCHERS = Collections.singletonList(MethodMatcher.create().typeDefinition("java.sql.DriverManager").name("getConnection").withAnyParameters());

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return METHOD_MATCHERS;
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        Arguments args = mit.arguments();
        if (args.size() > 2) {
            this.checkEmptyValue(mit, (ExpressionTree)args.get(2));
        }
        if (args.size() == 1) {
            this.checkUrlContainsEmptyPassword(mit);
        }
    }

    private void checkEmptyValue(MethodInvocationTree mit, ExpressionTree expression) {
        String literal = ConstantUtils.resolveAsStringConstant(expression);
        if (literal != null && literal.trim().isEmpty()) {
            this.reportIssue((Tree)mit, MESSAGE);
        }
    }

    private void checkUrlContainsEmptyPassword(MethodInvocationTree mit) {
        ExpressionTree urlArgument = (ExpressionTree)mit.arguments().get(0);
        String url = ConstantUtils.resolveAsStringConstant(urlArgument);
        if (url != null && (EmptyDatabasePasswordCheck.urlContainsEmptyPassword(url, MYSQL_URL_PATTERN) || EmptyDatabasePasswordCheck.urlContainsEmptyPassword(url, ORACLE_URL_PATTERN) || EMPTY_PASSWORD_PATTERN.matcher(url).matches())) {
            this.reportIssue((Tree)mit, MESSAGE);
        }
    }

    private static boolean urlContainsEmptyPassword(String url, Pattern urlPattern) {
        Matcher matcher = urlPattern.matcher(url);
        return matcher.matches() && matcher.group("password").trim().isEmpty();
    }
}

