/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3510")
public class HostnameVerifierImplementationCheck
extends IssuableSubscriptionVisitor {
    private static final String ISSUE_MESSAGE = "Do not unconditionally return true in this method.";
    private static final TypeCriteria TYPE_CRITERIA_STRING = TypeCriteria.is((String)"java.lang.String");
    private static final TypeCriteria TYPE_CRITERIA_SSL_SESSION = TypeCriteria.is((String)"javax.net.ssl.SSLSession");
    private static final MethodMatcher VERIFY_METHOD_MATCHER = MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"javax.net.ssl.HostnameVerifier")).name("verify").addParameter(TYPE_CRITERIA_STRING).addParameter(TYPE_CRITERIA_SSL_SESSION);

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD, (Object)Tree.Kind.LAMBDA_EXPRESSION);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        if (tree.kind().equals((Object)Tree.Kind.METHOD)) {
            this.checkMethodDefinition((MethodTree)tree);
        } else {
            this.checkLambdaDefinition((LambdaExpressionTree)tree);
        }
    }

    private void checkMethodDefinition(MethodTree tree) {
        BlockTree blockTree = tree.block();
        if (VERIFY_METHOD_MATCHER.matches(tree) && blockTree != null) {
            this.checkBlock(blockTree);
        }
    }

    private void checkLambdaDefinition(LambdaExpressionTree lambdaExpression) {
        Tree lambdaBody = lambdaExpression.body();
        if (HostnameVerifierImplementationCheck.isHostnameVerifierSignature(lambdaExpression)) {
            if (lambdaBody.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
                this.checkBlock((BlockTree)lambdaBody);
            } else if (HostnameVerifierImplementationCheck.isTrueLiteral(lambdaBody)) {
                this.reportIssue(lambdaBody, ISSUE_MESSAGE);
            }
        }
    }

    private void checkBlock(BlockTree blockTree) {
        BlockTree innerBlock = blockTree;
        while (innerBlock.body().size() == 1 && ((StatementTree)innerBlock.body().get(0)).is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            innerBlock = (BlockTree)innerBlock.body().get(0);
        }
        List<StatementTree> statementTreeList = innerBlock.body().stream().filter(statementTree -> !statementTree.is(new Tree.Kind[]{Tree.Kind.EMPTY_STATEMENT})).collect(Collectors.toList());
        if (HostnameVerifierImplementationCheck.isReturnTrueStatement(statementTreeList)) {
            this.reportIssue((Tree)statementTreeList.get(0), ISSUE_MESSAGE);
        }
    }

    private static boolean isHostnameVerifierSignature(LambdaExpressionTree lambdaExpressionTree) {
        return lambdaExpressionTree.symbolType().isSubtypeOf("javax.net.ssl.HostnameVerifier");
    }

    private static boolean isReturnTrueStatement(List<StatementTree> statementTreeList) {
        if (statementTreeList.size() == 1 && statementTreeList.get(0).is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT})) {
            ExpressionTree expression = ((ReturnStatementTree)statementTreeList.get(0)).expression();
            return HostnameVerifierImplementationCheck.isTrueLiteral((Tree)expression);
        }
        return false;
    }

    private static boolean isTrueLiteral(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION}) || tree.is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL})) {
            ExpressionTree expression = ExpressionUtils.skipParentheses((ExpressionTree)((ExpressionTree)tree));
            return LiteralUtils.isTrue((Tree)expression);
        }
        return false;
    }
}

