/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.NameCriteria;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;

@Rule(key="S4825")
public class HttpRequestsHotspotCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Arrays.asList(MethodMatcher.create().typeDefinition("java.net.URL").name("openConnection").withAnyParameters(), MethodMatcher.create().typeDefinition("jdk.incubator.http.HttpClient").name(NameCriteria.startsWith((String)"send")).withAnyParameters(), MethodMatcher.create().typeDefinition("java.net.http.HttpClient").name(NameCriteria.startsWith((String)"send")).withAnyParameters(), MethodMatcher.create().typeDefinition("org.apache.http.client.HttpClient").name("execute").withAnyParameters(), MethodMatcher.create().typeDefinition("org.apache.http.HttpClientConnection").name(NameCriteria.startsWith((String)"send")).withAnyParameters(), MethodMatcher.create().typeDefinition("com.google.api.client.http.HttpRequest").name(NameCriteria.startsWith((String)"execute")).withAnyParameters());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (!"openConnection".equals(mit.symbol().name()) || HttpRequestsHotspotCheck.isCastToHttpUrlConnection(mit.parent())) {
            this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), "Make sure that this http request is sent safely.");
        }
    }

    private static boolean isCastToHttpUrlConnection(Tree parent) {
        if (parent.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION})) {
            return HttpRequestsHotspotCheck.isCastToHttpUrlConnection(parent.parent());
        }
        if (parent.is(new Tree.Kind[]{Tree.Kind.TYPE_CAST})) {
            return ((TypeCastTree)parent).type().symbolType().is("java.net.HttpURLConnection");
        }
        return false;
    }
}

