/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4784")
public class RegexHotspotCheck
extends IssuableSubscriptionVisitor {
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final MethodMatcherCollection REGEX_HOTSPOTS = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{MethodMatcher.create().typeDefinition("java.lang.String").name("matches").addParameter("java.lang.String"), MethodMatcher.create().typeDefinition("java.lang.String").name("replaceAll").withAnyParameters(), MethodMatcher.create().typeDefinition("java.lang.String").name("replaceFirst").withAnyParameters(), MethodMatcher.create().typeDefinition("java.util.regex.Pattern").name("compile").withAnyParameters(), MethodMatcher.create().typeDefinition("java.util.regex.Pattern").name("matches").withAnyParameters()});
    private static final String MESSAGE = "Make sure that using a regular expression is safe here.";
    private static final List<String> HOTSPOT_ANNOTATION_TYPES = Arrays.asList("javax.validation.constraints.Pattern", "javax.validation.constraints.Email", "org.hibernate.validator.constraints.URL");

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD_INVOCATION, Tree.Kind.METHOD_REFERENCE, Tree.Kind.ANNOTATION);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            Arguments args;
            if (REGEX_HOTSPOTS.anyMatch((MethodInvocationTree)tree) && !(args = ((MethodInvocationTree)tree).arguments()).isEmpty()) {
                this.reportIssue((Tree)args.get(0), MESSAGE);
            }
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_REFERENCE})) {
            if (REGEX_HOTSPOTS.anyMatch((MethodReferenceTree)tree)) {
                this.reportIssue((Tree)((MethodReferenceTree)tree).method(), MESSAGE);
            }
        } else {
            AnnotationTree annotationTree = (AnnotationTree)tree;
            if (HOTSPOT_ANNOTATION_TYPES.stream().anyMatch(t -> annotationTree.annotationType().symbolType().is(t))) {
                annotationTree.arguments().stream().filter(RegexHotspotCheck::isRegexpParameter).findFirst().ifPresent(e -> this.reportIssue((Tree)e, MESSAGE));
            }
        }
    }

    private static boolean isRegexpParameter(ExpressionTree expr) {
        if (expr.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT}) && ((AssignmentExpressionTree)expr).variable().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return ((IdentifierTree)((AssignmentExpressionTree)expr).variable()).name().equals("regexp");
        }
        return false;
    }
}

