/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ConstantUtils;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S4499")
public class SMTPSSLServerIdentityCheck
extends AbstractMethodDetection {
    private static final String APACHE_EMAIL = "org.apache.commons.mail.Email";
    private static final String BOOLEAN = "boolean";
    private static final String HASHTABLE = "java.util.Hashtable";
    private static final Set<String> ENABLING_SSL_METHOD_NAMES = new HashSet<String>(Arrays.asList("setSSL", "setSSLOnConnect", "setTLS", "setStartTLSEnabled", "setStartTLSRequired"));
    private static final MethodMatcher ENABLING_SSL_METHODS = MethodMatcher.create().typeDefinition(TypeCriteria.is((String)"org.apache.commons.mail.Email")).name(ENABLING_SSL_METHOD_NAMES::contains).addParameter("boolean");
    private static final MethodMatcher HASHTABLE_PUT = MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"java.util.Hashtable")).name("put").withAnyParameters();

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)ENABLING_SSL_METHODS, (Object)HASHTABLE_PUT);
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        MethodTree method = ExpressionUtils.getEnclosingMethod((ExpressionTree)mit);
        if (method != null) {
            Arguments args = mit.arguments();
            if (ENABLING_SSL_METHODS.matches(mit) && LiteralUtils.isTrue((Tree)((Tree)args.get(0)))) {
                MethodBodyApacheVisitor apacheVisitor = new MethodBodyApacheVisitor();
                method.accept((TreeVisitor)apacheVisitor);
                if (!apacheVisitor.isSecured) {
                    this.reportIssue((Tree)mit, "Enable server identity validation on this SMTP SSL connection.");
                }
            } else if (HASHTABLE_PUT.matches(mit) && "mail.smtp.socketFactory.class".equals(ConstantUtils.resolveAsStringConstant((ExpressionTree)args.get(0))) && "javax.net.ssl.SSLSocketFactory".equals(ConstantUtils.resolveAsStringConstant((ExpressionTree)args.get(1)))) {
                MethodBodyHashtableVisitor hashVisitor = new MethodBodyHashtableVisitor();
                method.accept((TreeVisitor)hashVisitor);
                if (!hashVisitor.isSecured) {
                    this.reportIssue((Tree)mit, "Enable server identity validation, set \"mail.smtp.ssl.checkserveridentity\" to true");
                }
            }
        }
        super.onMethodInvocationFound(mit);
    }

    private static boolean isNotFalse(ExpressionTree expression) {
        return !LiteralUtils.isFalse((Tree)expression);
    }

    private static class MethodBodyApacheVisitor
    extends BaseTreeVisitor {
        private boolean isSecured = false;
        private static final MethodMatcher SET_SSL_CHECK_SERVER_ID = MethodMatcher.create().typeDefinition("org.apache.commons.mail.Email").name("setSSLCheckServerIdentity").addParameter("boolean");

        private MethodBodyApacheVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree mit) {
            if (SET_SSL_CHECK_SERVER_ID.matches(mit) && SMTPSSLServerIdentityCheck.isNotFalse((ExpressionTree)mit.arguments().get(0))) {
                this.isSecured = true;
            }
            super.visitMethodInvocation(mit);
        }
    }

    private static class MethodBodyHashtableVisitor
    extends BaseTreeVisitor {
        private boolean isSecured = false;

        private MethodBodyHashtableVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree mit) {
            Arguments args = mit.arguments();
            if (HASHTABLE_PUT.matches(mit) && "mail.smtp.ssl.checkserveridentity".equals(ConstantUtils.resolveAsStringConstant((ExpressionTree)args.get(0))) && SMTPSSLServerIdentityCheck.isNotFalse((ExpressionTree)args.get(1))) {
                this.isSecured = true;
            }
            super.visitMethodInvocation(mit);
        }
    }
}

