/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Collections;
import java.util.List;
import javax.xml.transform.TransformerFactory;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ConstantUtils;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S4435")
public class SecureXmlTransformerCheck
extends AbstractMethodDetection {
    private static final String TRANSFORMER_FACTORY_CLASS_NAME = TransformerFactory.class.getName();

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Collections.singletonList(MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)TRANSFORMER_FACTORY_CLASS_NAME)).name("newInstance").withAnyParameters());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree methodInvocation) {
        MethodTree enclosingMethod = ExpressionUtils.getEnclosingMethod((ExpressionTree)methodInvocation);
        if (enclosingMethod == null) {
            return;
        }
        MethodBodyVisitor visitor = new MethodBodyVisitor();
        enclosingMethod.accept((TreeVisitor)visitor);
        if (!visitor.foundCallsToSecuringMethods()) {
            this.reportIssue((Tree)methodInvocation.methodSelect(), "Secure this \"Transformer\" by either disabling external DTDs or enabling secure processing.");
        }
    }

    static /* synthetic */ String access$200() {
        return TRANSFORMER_FACTORY_CLASS_NAME;
    }

    private static class MethodBodyVisitor
    extends BaseTreeVisitor {
        private static final MethodMatcher SET_FEATURE = MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)SecureXmlTransformerCheck.access$200())).name("setFeature").parameters(new String[]{"java.lang.String", "boolean"});
        private static final MethodMatcher SET_ATTRIBUTE = MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)SecureXmlTransformerCheck.access$200())).name("setAttribute").parameters(new String[]{"java.lang.String", "java.lang.Object"});
        private boolean hasSecureProcessingFeature = false;
        private boolean hasSecuredExternalDtd = false;
        private boolean hasSecuredExternalStylesheet = false;

        private MethodBodyVisitor() {
        }

        private boolean foundCallsToSecuringMethods() {
            return this.hasSecureProcessingFeature || this.hasSecuredExternalDtd && this.hasSecuredExternalStylesheet;
        }

        public void visitMethodInvocation(MethodInvocationTree methodInvocation) {
            Arguments arguments = methodInvocation.arguments();
            if (SET_FEATURE.matches(methodInvocation) && "http://javax.xml.XMLConstants/feature/secure-processing".equals(ConstantUtils.resolveAsStringConstant((ExpressionTree)arguments.get(0))) && LiteralUtils.isTrue((Tree)((Tree)arguments.get(1)))) {
                this.hasSecureProcessingFeature = true;
            }
            if (SET_ATTRIBUTE.matches(methodInvocation)) {
                String attributeName = ConstantUtils.resolveAsStringConstant((ExpressionTree)arguments.get(0));
                String attributeValue = ConstantUtils.resolveAsStringConstant((ExpressionTree)arguments.get(1));
                if ("".equals(attributeValue)) {
                    if ("http://javax.xml.XMLConstants/property/accessExternalDTD".equals(attributeName)) {
                        this.hasSecuredExternalDtd = true;
                    } else if ("http://javax.xml.XMLConstants/property/accessExternalStylesheet".equals(attributeName)) {
                        this.hasSecuredExternalStylesheet = true;
                    }
                }
            }
            super.visitMethodInvocation(methodInvocation);
        }
    }
}

