/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.NameCriteria;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4817")
public class XPathUsageCheck
extends AbstractMethodDetection {
    private static final String MESSAGE = "Make sure that executing this XPATH expression is safe here.";
    private static final String APACHE_JXPATH_CONTEXT = "org.apache.commons.jxpath.JXPathContext";
    private static final String APACHE_XALAN_XPATH_API = "org.apache.xpath.XPathAPI";
    private static final String JAVA_LANG_STRING = "java.lang.String";

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Arrays.asList(MethodMatcher.create().typeDefinition("javax.xml.xpath.XPath").name("compile").parameters(new String[]{JAVA_LANG_STRING}), MethodMatcher.create().typeDefinition("javax.xml.xpath.XPath").name("evaluate").withAnyParameters(), MethodMatcher.create().typeDefinition("org.apache.xml.security.utils.XPathAPI").name("evaluate").withAnyParameters(), MethodMatcher.create().typeDefinition("org.apache.xml.security.utils.XPathAPI").name("selectNodeList").withAnyParameters(), MethodMatcher.create().typeDefinition(APACHE_XALAN_XPATH_API).name("eval").withAnyParameters(), MethodMatcher.create().typeDefinition(APACHE_XALAN_XPATH_API).name("selectNodeIterator").withAnyParameters(), MethodMatcher.create().typeDefinition(APACHE_XALAN_XPATH_API).name("selectNodeList").withAnyParameters(), MethodMatcher.create().typeDefinition(APACHE_XALAN_XPATH_API).name("selectSingleNode").withAnyParameters(), MethodMatcher.create().typeDefinition(APACHE_JXPATH_CONTEXT).name(NameCriteria.startsWith((String)"compile")).parameters(new String[]{JAVA_LANG_STRING}), MethodMatcher.create().typeDefinition(APACHE_JXPATH_CONTEXT).name(NameCriteria.startsWith((String)"createPath")).withAnyParameters(), MethodMatcher.create().typeDefinition(APACHE_JXPATH_CONTEXT).name("getPointer").parameters(new String[]{JAVA_LANG_STRING}), MethodMatcher.create().typeDefinition(APACHE_JXPATH_CONTEXT).name("getValue").withAnyParameters(), MethodMatcher.create().typeDefinition(APACHE_JXPATH_CONTEXT).name("iterate").parameters(new String[]{JAVA_LANG_STRING}), MethodMatcher.create().typeDefinition(APACHE_JXPATH_CONTEXT).name("iteratePointers").parameters(new String[]{JAVA_LANG_STRING}), MethodMatcher.create().typeDefinition(APACHE_JXPATH_CONTEXT).name("removeAll").parameters(new String[]{JAVA_LANG_STRING}), MethodMatcher.create().typeDefinition(APACHE_JXPATH_CONTEXT).name("removePath").parameters(new String[]{JAVA_LANG_STRING}), MethodMatcher.create().typeDefinition(APACHE_JXPATH_CONTEXT).name("selectNodes").parameters(new String[]{JAVA_LANG_STRING}), MethodMatcher.create().typeDefinition(APACHE_JXPATH_CONTEXT).name("selectSingleNode").parameters(new String[]{JAVA_LANG_STRING}), MethodMatcher.create().typeDefinition(APACHE_JXPATH_CONTEXT).name("setValue").parameters(new String[]{JAVA_LANG_STRING, "java.lang.Object"}));
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), MESSAGE);
    }
}

