/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ConstantUtils;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

@Rule(key="S2755")
public class XmlExternalEntityProcessingCheck
extends IssuableSubscriptionVisitor {
    private static final String XML_INPUT_FACTORY_CLASS_NAME = XMLInputFactory.class.getName();
    private static final String SAX_PARSER_FACTORY_CLASS_NAME = SAXParserFactory.class.getName();
    private static final String XML_READER_FACTORY_CLASS_NAME = XMLReaderFactory.class.getName();
    private static final String XML_READER_CLASS_NAME = XMLReader.class.getName();
    private static final String DOCUMENT_BUILDER_FACTORY_CLASS_NAME = DocumentBuilderFactory.class.getName();
    private static final String VALIDATOR_CLASS_NAME = Validator.class.getName();
    private static final String SCHEMA_CLASS_NAME = Schema.class.getName();
    private static final MethodMatcher CREATE_XML_READER_MATCHER = MethodMatcher.create().typeDefinition(XML_READER_FACTORY_CLASS_NAME).name("createXMLReader").withAnyParameters();
    private static final MethodMatcher CREATE_VALIDATOR = MethodMatcher.create().typeDefinition(SCHEMA_CLASS_NAME).name("newValidator").withAnyParameters();
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private final List<XxeCheck> xxeChecks = Arrays.asList(new XxeCheck(XmlExternalEntityProcessingCheck.newInstanceMethod(XML_INPUT_FACTORY_CLASS_NAME), new XMLInputFactorySecuringPredicate()), new XxeCheck(XmlExternalEntityProcessingCheck.newInstanceMethod(SAX_PARSER_FACTORY_CLASS_NAME), new SecureProcessingFeaturePredicate(SAX_PARSER_FACTORY_CLASS_NAME)), new XxeCheck(XmlExternalEntityProcessingCheck.newInstanceMethod(DOCUMENT_BUILDER_FACTORY_CLASS_NAME), new SecureProcessingFeaturePredicate(DOCUMENT_BUILDER_FACTORY_CLASS_NAME)), new XxeCheck(CREATE_XML_READER_MATCHER, new SecureProcessingFeaturePredicate(XML_READER_CLASS_NAME)), new XxeCheck(CREATE_VALIDATOR, new AccessExternalDTDOrSchemaPredicate(VALIDATOR_CLASS_NAME)));

    private static MethodMatcher newInstanceMethod(String className) {
        return MethodMatcher.create().typeDefinition(className).name("newInstance").withAnyParameters();
    }

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        this.xxeChecks.forEach(check -> ((XxeCheck)check).checkMethodInvocation((MethodInvocationTree)tree));
    }

    static /* synthetic */ String access$800() {
        return XML_INPUT_FACTORY_CLASS_NAME;
    }

    private static class AccessExternalDTDOrSchemaPredicate
    implements Predicate<MethodInvocationTree> {
        private final MethodMatcher methodMatcher;
        private boolean externalDTDDisabled = false;
        private boolean externalSchemaDisabled = false;

        private AccessExternalDTDOrSchemaPredicate(String className) {
            this.methodMatcher = AccessExternalDTDOrSchemaPredicate.setPropertyMethodMatcher(className);
        }

        @Override
        public boolean test(MethodInvocationTree methodInvocation) {
            if (this.methodMatcher.matches(methodInvocation)) {
                Arguments arguments = methodInvocation.arguments();
                String propertyName = ConstantUtils.resolveAsStringConstant((ExpressionTree)arguments.get(0));
                String propertyValue = ConstantUtils.resolveAsStringConstant((ExpressionTree)arguments.get(1));
                if ("".equals(propertyValue) && "http://javax.xml.XMLConstants/property/accessExternalDTD".equals(propertyName)) {
                    this.externalDTDDisabled = true;
                }
                if ("".equals(propertyValue) && "http://javax.xml.XMLConstants/property/accessExternalSchema".equals(propertyName)) {
                    this.externalSchemaDisabled = true;
                }
                return this.externalDTDDisabled && this.externalSchemaDisabled;
            }
            return false;
        }

        private static MethodMatcher setPropertyMethodMatcher(String className) {
            return MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)className)).name("setProperty").parameters(new String[]{XmlExternalEntityProcessingCheck.JAVA_LANG_STRING, "java.lang.Object"});
        }
    }

    private static class SecureProcessingFeaturePredicate
    implements Predicate<MethodInvocationTree> {
        private final MethodMatcher methodMatcher;

        private SecureProcessingFeaturePredicate(String className) {
            this.methodMatcher = SecureProcessingFeaturePredicate.setFeatureMethodMatcher(className);
        }

        @Override
        public boolean test(MethodInvocationTree methodInvocation) {
            if (this.methodMatcher.matches(methodInvocation)) {
                Arguments arguments = methodInvocation.arguments();
                String featureName = ConstantUtils.resolveAsStringConstant((ExpressionTree)arguments.get(0));
                return Boolean.TRUE.equals(ConstantUtils.resolveAsBooleanConstant((ExpressionTree)arguments.get(1))) && ("http://javax.xml.XMLConstants/feature/secure-processing".equals(featureName) || "http://apache.org/xml/features/disallow-doctype-decl".equals(featureName));
            }
            return false;
        }

        private static MethodMatcher setFeatureMethodMatcher(String className) {
            return MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)className)).name("setFeature").parameters(new String[]{XmlExternalEntityProcessingCheck.JAVA_LANG_STRING, "boolean"});
        }
    }

    private static class XMLInputFactorySecuringPredicate
    implements Predicate<MethodInvocationTree> {
        private static final MethodMatcher SET_PROPERTY = MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)XmlExternalEntityProcessingCheck.access$800())).name("setProperty").parameters(new String[]{"java.lang.String", "java.lang.Object"});

        private XMLInputFactorySecuringPredicate() {
        }

        @Override
        public boolean test(MethodInvocationTree methodInvocation) {
            String propertyName;
            Arguments arguments = methodInvocation.arguments();
            if (SET_PROPERTY.matches(methodInvocation) && ("javax.xml.stream.isSupportingExternalEntities".equals(propertyName = ConstantUtils.resolveAsStringConstant((ExpressionTree)arguments.get(0))) || "javax.xml.stream.supportDTD".equals(propertyName))) {
                ExpressionTree propertyValue = (ExpressionTree)arguments.get(1);
                return Boolean.FALSE.equals(ConstantUtils.resolveAsBooleanConstant(propertyValue));
            }
            return false;
        }
    }

    private static class MethodVisitor
    extends BaseTreeVisitor {
        private final Predicate<MethodInvocationTree> securingInvocationPredicate;
        private boolean isExternalEntityProcessingDisabled = false;

        private MethodVisitor(Predicate<MethodInvocationTree> securingInvocationPredicate) {
            this.securingInvocationPredicate = securingInvocationPredicate;
        }

        public void visitMethodInvocation(MethodInvocationTree methodInvocation) {
            if (this.securingInvocationPredicate.test(methodInvocation)) {
                this.isExternalEntityProcessingDisabled = true;
            }
            super.visitMethodInvocation(methodInvocation);
        }
    }

    private class XxeCheck {
        private final MethodMatcher triggeringInvocationMatcher;
        private final Predicate<MethodInvocationTree> securingInvocationPredicate;

        private XxeCheck(MethodMatcher triggeringInvocationMatcher, Predicate<MethodInvocationTree> securingInvocationPredicate) {
            this.triggeringInvocationMatcher = triggeringInvocationMatcher;
            this.securingInvocationPredicate = securingInvocationPredicate;
        }

        private void checkMethodInvocation(MethodInvocationTree methodInvocation) {
            MethodTree enclosingMethod;
            if (this.triggeringInvocationMatcher.matches(methodInvocation) && (enclosingMethod = ExpressionUtils.getEnclosingMethod((ExpressionTree)methodInvocation)) != null) {
                if (this.securingInvocationPredicate instanceof AccessExternalDTDOrSchemaPredicate) {
                    ((AccessExternalDTDOrSchemaPredicate)this.securingInvocationPredicate).externalDTDDisabled = false;
                    ((AccessExternalDTDOrSchemaPredicate)this.securingInvocationPredicate).externalSchemaDisabled = false;
                }
                MethodVisitor methodVisitor = new MethodVisitor(this.securingInvocationPredicate);
                enclosingMethod.accept((TreeVisitor)methodVisitor);
                if (!methodVisitor.isExternalEntityProcessingDisabled) {
                    XmlExternalEntityProcessingCheck.this.reportIssue((Tree)methodInvocation.methodSelect(), "Disable XML external entity (XXE) processing.");
                }
            }
        }
    }
}

