/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ConstantUtils;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4601")
public class SpringAntMatcherOrderCheck
extends AbstractMethodDetection {
    private static final Pattern MATCHER_SPECIAL_CHAR = Pattern.compile("[?*{]");
    private static final MethodMatcher ANT_MATCHERS = MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"org.springframework.security.config.annotation.web.AbstractRequestMatcherRegistry")).name("antMatchers").addParameter("java.lang.String[]");

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Collections.singletonList(MethodMatcher.create().typeDefinition(TypeCriteria.is((String)"org.springframework.security.config.annotation.web.builders.HttpSecurity")).name("authorizeRequests").withAnyParameters());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree method) {
        List<StringConstant> antPatterns = SpringAntMatcherOrderCheck.collectAntPatterns(method);
        for (int indexToCheck = 1; indexToCheck < antPatterns.size(); ++indexToCheck) {
            this.checkAntPatternAt(antPatterns, indexToCheck);
        }
    }

    private void checkAntPatternAt(List<StringConstant> antPatterns, int indexToCheck) {
        StringConstant patternToCheck = antPatterns.get(indexToCheck);
        StringConstant incompatiblePattern = SpringAntMatcherOrderCheck.firstIncompatiblePreviousPattern(patternToCheck, antPatterns, indexToCheck);
        if (incompatiblePattern != null) {
            List<JavaFileScannerContext.Location> secondary = Collections.singletonList(new JavaFileScannerContext.Location("Less restrictive", (Tree)incompatiblePattern.expression));
            this.reportIssue((Tree)patternToCheck.expression, "Reorder the URL patterns from most to less specific, the pattern \"" + patternToCheck.value + "\" should occurs before \"" + incompatiblePattern.value + "\".", secondary, null);
        }
    }

    @CheckForNull
    private static StringConstant firstIncompatiblePreviousPattern(StringConstant patternToCheck, List<StringConstant> antPatterns, int antPatternsSize) {
        for (int i = 0; i < antPatternsSize; ++i) {
            StringConstant previousPattern = antPatterns.get(i);
            if (!SpringAntMatcherOrderCheck.matches(previousPattern.value, patternToCheck.value)) continue;
            return previousPattern;
        }
        return null;
    }

    private static List<StringConstant> collectAntPatterns(MethodInvocationTree method) {
        ArrayList<StringConstant> antPatterns = new ArrayList<StringConstant>();
        MethodInvocationTree parentMethod = SpringAntMatcherOrderCheck.parentMethodInvocation(method);
        while (parentMethod != null) {
            if (ANT_MATCHERS.matches(parentMethod)) {
                antPatterns.addAll(SpringAntMatcherOrderCheck.antMatchersPatterns(parentMethod));
            }
            parentMethod = SpringAntMatcherOrderCheck.parentMethodInvocation(parentMethod);
        }
        return antPatterns;
    }

    @CheckForNull
    private static MethodInvocationTree parentMethodInvocation(MethodInvocationTree method) {
        Tree parent = method.parent();
        if (parent.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            parent = parent.parent();
            if (parent.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                return (MethodInvocationTree)parent;
            }
        }
        return null;
    }

    @VisibleForTesting
    static boolean matches(String pattern, String text) {
        if (pattern.equals(text)) {
            return true;
        }
        if (pattern.endsWith("**") && text.startsWith(pattern.substring(0, pattern.length() - 2))) {
            return true;
        }
        boolean antPatternContainsRegExp = pattern.contains("{");
        boolean textIsAlsoAnAntPattern = MATCHER_SPECIAL_CHAR.matcher(text).find();
        if (pattern.isEmpty() || antPatternContainsRegExp || textIsAlsoAnAntPattern) {
            return false;
        }
        return text.matches(SpringAntMatcherOrderCheck.antMatcherToRegEx(pattern));
    }

    @VisibleForTesting
    static String antMatcherToRegEx(String pattern) {
        return SpringAntMatcherOrderCheck.escapeRegExpChars(pattern).replace("?", "[^/]").replace("**", "$$").replace("*", "[^/]*").replace("$$", ".*");
    }

    @VisibleForTesting
    static String escapeRegExpChars(String pattern) {
        return pattern.replaceAll("([.(){}+|^$\\[\\]\\\\])", "\\\\$1");
    }

    private static List<StringConstant> antMatchersPatterns(MethodInvocationTree mit) {
        return mit.arguments().stream().map(x$0 -> StringConstant.of(x$0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static class StringConstant {
        private final ExpressionTree expression;
        private final String value;

        private StringConstant(ExpressionTree expression, String value) {
            this.expression = expression;
            this.value = value;
        }

        @CheckForNull
        private static StringConstant of(ExpressionTree expression) {
            String value = ConstantUtils.resolveAsStringConstant(expression);
            if (value != null) {
                return new StringConstant(expression, value);
            }
            return null;
        }
    }
}

