/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4529")
public class SpringEndpointsCheck
extends IssuableSubscriptionVisitor {
    private static final String REQUEST_MAPPING_ANNOTATION = "org.springframework.web.bind.annotation.RequestMapping";
    private static final String MESSAGE = "Make sure that exposing this HTTP endpoint is safe here.";

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        MethodTree methodTree = (MethodTree)tree;
        List annotations = methodTree.modifiers().annotations();
        annotations.stream().filter(SpringEndpointsCheck::isSpringWebHandler).forEach(annotationTree -> this.reportIssue((Tree)methodTree.simpleName(), MESSAGE));
    }

    private static boolean isSpringWebHandler(AnnotationTree annotationTree) {
        Type annotationType = annotationTree.annotationType().symbolType();
        return annotationType.is(REQUEST_MAPPING_ANNOTATION) || annotationType.symbol().metadata().isAnnotatedWith(REQUEST_MAPPING_ANNOTATION);
    }
}

