/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.unused;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1068")
public class UnusedPrivateFieldCheck
extends IssuableSubscriptionVisitor {
    private static final Tree.Kind[] ASSIGNMENT_KINDS = new Tree.Kind[]{Tree.Kind.ASSIGNMENT, Tree.Kind.MULTIPLY_ASSIGNMENT, Tree.Kind.DIVIDE_ASSIGNMENT, Tree.Kind.REMAINDER_ASSIGNMENT, Tree.Kind.PLUS_ASSIGNMENT, Tree.Kind.MINUS_ASSIGNMENT, Tree.Kind.LEFT_SHIFT_ASSIGNMENT, Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.AND_ASSIGNMENT, Tree.Kind.XOR_ASSIGNMENT, Tree.Kind.OR_ASSIGNMENT};
    private List<ClassTree> classes = Lists.newArrayList();
    private ListMultimap<Symbol, IdentifierTree> assignments = ArrayListMultimap.create();
    private Set<String> unknownIdentifiers = new HashSet<String>();
    private boolean hasNativeMethod = false;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS, (Object)Tree.Kind.METHOD, (Object)Tree.Kind.EXPRESSION_STATEMENT, (Object)Tree.Kind.IDENTIFIER);
    }

    public void leaveFile(JavaFileScannerContext context) {
        if (!this.hasNativeMethod) {
            this.classes.forEach(this::checkClassFields);
        }
        this.classes.clear();
        this.assignments.clear();
        this.unknownIdentifiers.clear();
        this.hasNativeMethod = false;
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        switch (tree.kind()) {
            case METHOD: {
                this.checkIfNativeMethod((MethodTree)tree);
                break;
            }
            case CLASS: {
                this.classes.add((ClassTree)tree);
                break;
            }
            case EXPRESSION_STATEMENT: {
                this.collectAssignment(((ExpressionStatementTree)tree).expression());
                break;
            }
            case IDENTIFIER: {
                this.collectUnknownIdentifier((IdentifierTree)tree);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected subscribed tree.");
            }
        }
    }

    private void collectUnknownIdentifier(IdentifierTree identifier) {
        if (identifier.symbol().isUnknown() && !UnusedPrivateFieldCheck.isMethodIdentifier(identifier)) {
            this.unknownIdentifiers.add(identifier.name());
        }
    }

    private static boolean isMethodIdentifier(IdentifierTree identifier) {
        Tree parent;
        for (parent = identifier.parent(); parent != null && !parent.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION, Tree.Kind.METHOD_REFERENCE}); parent = parent.parent()) {
        }
        if (parent == null) {
            return false;
        }
        if (parent.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            return identifier.equals(ExpressionUtils.methodName((MethodInvocationTree)((MethodInvocationTree)parent)));
        }
        return identifier.equals(((MethodReferenceTree)parent).method());
    }

    private void checkIfNativeMethod(MethodTree method) {
        if (ModifiersUtils.hasModifier((ModifiersTree)method.modifiers(), (Modifier)Modifier.NATIVE)) {
            this.hasNativeMethod = true;
        }
    }

    private void checkClassFields(ClassTree classTree) {
        classTree.members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})).map(VariableTree.class::cast).forEach(this::checkIfUnused);
    }

    public void checkIfUnused(VariableTree tree) {
        if (UnusedPrivateFieldCheck.hasNoAnnotation(tree)) {
            Symbol symbol = tree.symbol();
            String name = symbol.name();
            if (symbol.isPrivate() && this.onlyUsedInVariableAssignment(symbol) && !"serialVersionUID".equals(name) && !this.unknownIdentifiers.contains(name)) {
                this.reportIssue((Tree)tree.simpleName(), "Remove this unused \"" + name + "\" private field.");
            }
        }
    }

    private boolean onlyUsedInVariableAssignment(Symbol symbol) {
        return symbol.usages().size() == this.assignments.get((Object)symbol).size();
    }

    private static boolean hasNoAnnotation(VariableTree tree) {
        return tree.modifiers().annotations().isEmpty();
    }

    private void collectAssignment(ExpressionTree expressionTree) {
        if (expressionTree.is(ASSIGNMENT_KINDS)) {
            this.addAssignment(((AssignmentExpressionTree)expressionTree).variable());
        }
    }

    private void addAssignment(ExpressionTree tree) {
        ExpressionTree variable = ExpressionUtils.skipParentheses((ExpressionTree)tree);
        if (variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            this.addAssignment((IdentifierTree)variable);
        } else if (variable.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            this.addAssignment(((MemberSelectExpressionTree)variable).identifier());
        }
    }

    private void addAssignment(IdentifierTree identifier) {
        Symbol reference = identifier.symbol();
        if (!reference.isUnknown()) {
            this.assignments.put((Object)reference, (Object)identifier);
        }
    }
}

