/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.xml.hibernate;

import java.util.stream.StreamSupport;
import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonar.java.xml.XPathXmlCheck;
import org.sonar.java.xml.XmlCheckContext;
import org.sonar.plugins.java.api.JavaCheck;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Rule(key="S3822")
public class DatabaseSchemaUpdateCheck
extends XPathXmlCheck {
    private XPathExpression hibernateHbm2ddlAutoProperty;

    public void precompileXPathExpressions(XmlCheckContext context) {
        this.hibernateHbm2ddlAutoProperty = context.compile("//property[@name='hibernate.hbm2ddl.auto']");
    }

    public void scanFileWithXPathExpressions(XmlCheckContext context) {
        StreamSupport.stream(context.evaluateOnDocument(this.hibernateHbm2ddlAutoProperty).spliterator(), false).forEach(property -> this.checkProperty((Node)property, context));
    }

    private void checkProperty(Node property, XmlCheckContext context) {
        String value;
        NodeList children = property.getChildNodes();
        if (children.getLength() == 1 && !"none".equals(value = children.item(0).getNodeValue().trim()) && !"validate".equals(value)) {
            context.reportIssue((JavaCheck)this, property, "Use \"validate\" or remove this property.");
        }
    }
}

