/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.xml.maven;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.xml.maven.PomCheck;
import org.sonar.java.xml.maven.PomCheckContext;
import org.sonar.maven.model.LocatedTree;
import org.sonar.maven.model.maven2.MavenProject;

@Rule(key="S3423")
public class PomElementOrderCheck
implements PomCheck {
    private static final Comparator<LocatedTree> LINE_COMPARATOR = (l1, l2) -> Integer.compare(l1.startLocation().line(), l2.startLocation().line());

    public void scanFile(PomCheckContext context) {
        MavenProject project = context.getMavenProject();
        List<PomCheckContext.Location> issues = PomElementOrderCheck.checkPositions(new LocatedTree[]{project.getModelVersion(), project.getParent(), project.getGroupId(), project.getArtifactId(), project.getVersion(), project.getPackaging(), project.getName(), project.getDescription(), project.getUrl(), project.getInceptionYear(), project.getOrganization(), project.getLicenses(), project.getDevelopers(), project.getContributors(), project.getMailingLists(), project.getPrerequisites(), project.getModules(), project.getScm(), project.getIssueManagement(), project.getCiManagement(), project.getDistributionManagement(), project.getProperties(), project.getDependencyManagement(), project.getDependencies(), project.getRepositories(), project.getPluginRepositories(), project.getBuild(), project.getReporting(), project.getProfiles()});
        if (!issues.isEmpty()) {
            context.reportIssue((PomCheck)this, project.startLocation().line(), "Reorder the elements of this pom to match the recommended order.", issues);
        }
    }

    private static List<PomCheckContext.Location> checkPositions(LocatedTree ... trees) {
        List expectedOrder = Arrays.stream(trees).filter(Objects::nonNull).collect(Collectors.toList());
        List observedOrder = expectedOrder.stream().sorted(LINE_COMPARATOR).collect(Collectors.toList());
        int lastWrongPosition = -1;
        int firstWrongPosition = -1;
        for (int index = 0; index < expectedOrder.size(); ++index) {
            if (observedOrder.indexOf(expectedOrder.get(index)) == index) continue;
            lastWrongPosition = index;
            if (firstWrongPosition != -1) continue;
            firstWrongPosition = index;
        }
        if (lastWrongPosition == -1) {
            return Collections.emptyList();
        }
        ArrayList<PomCheckContext.Location> issues = new ArrayList<PomCheckContext.Location>();
        for (int index = firstWrongPosition; index <= lastWrongPosition; ++index) {
            issues.add(new PomCheckContext.Location("Expected position: " + (index + 1), ((LocatedTree)expectedOrder.get(index)).startLocation().line()));
        }
        return issues;
    }
}

